/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupService;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.Create;
import com.openexchange.group.internal.Delete;
import com.openexchange.group.internal.Update;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import java.util.Date;

public final class GroupServiceImpl
implements GroupService {
    @Override
    public void create(Context ctx, User user, Group group, boolean checkI18nNames) throws OXException {
        Create create = new Create(ctx, user, group, checkI18nNames);
        create.perform();
    }

    @Override
    public void update(Context ctx, User user, Group group, Date lastRead, boolean checkI18nNames) throws OXException {
        Update update = new Update(ctx, user, group, lastRead, checkI18nNames);
        update.perform();
    }

    @Override
    public void delete(Context ctx, User user, int groupId, Date lastRead) throws OXException {
        Delete delete = new Delete(ctx, user, groupId, lastRead);
        delete.perform();
    }

    @Override
    public Group getGroup(Context ctx, int groupId) throws OXException {
        return GroupStorage.getInstance().getGroup(groupId, ctx);
    }

    @Override
    public Group[] search(Context ctx, String pattern, boolean loadMembers) throws OXException {
        return GroupStorage.getInstance().searchGroups(pattern, loadMembers, ctx);
    }
}

