/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.outlook.OutlookFolderStorage;
import com.openexchange.folderstorage.outlook.OutlookFolderStorageRegistry;
import com.openexchange.folderstorage.outlook.sql.Delete;
import com.openexchange.folderstorage.outlook.sql.Duplicate;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DuplicateCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicateCleaner.class);

    private DuplicateCleaner() {
    }

    public static void cleanDuplicates(String treeId, StorageParameters storageParameters) throws OXException {
        DuplicateCleaner.cleanDuplicates(treeId, storageParameters, null);
    }

    public static String cleanDuplicates(String treeId, StorageParameters storageParameters, String lookUp) throws OXException {
        int userId;
        OutlookFolderStorage outlookFolderStorage = OutlookFolderStorage.getInstance();
        OutlookFolderStorageRegistry folderStorageRegistry = outlookFolderStorage.folderStorageRegistry;
        String realTreeId = outlookFolderStorage.realTreeId;
        int tree = Tools.getUnsignedInteger(treeId);
        int contextId = storageParameters.getContextId();
        Map<String, List<String>> name2ids = Duplicate.lookupDuplicateNames(contextId, tree, userId = storageParameters.getUserId());
        if (name2ids.isEmpty()) {
            return null;
        }
        boolean actionPerformed = false;
        String first = null;
        HashSet<String> ids = new HashSet<String>(name2ids.size());
        for (List<String> folderIds : name2ids.values()) {
            for (String folderId : folderIds) {
                if (null == first && null != lookUp && lookUp.equals(folderId)) {
                    first = folderId;
                }
                FolderStorage folderStorage = folderStorageRegistry.getFolderStorage(realTreeId, folderId);
                boolean started = folderStorage.startTransaction(storageParameters, true);
                try {
                    folderStorage.deleteFolder(realTreeId, folderId, storageParameters);
                    if (started) {
                        folderStorage.commitTransaction(storageParameters);
                    }
                    actionPerformed = true;
                    ids.add(folderId);
                }
                catch (OXException e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    LOG.warn("Deleting folder {} failed for tree {}", new Object[]{folderId, treeId, e});
                }
                catch (Exception e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    LOG.warn("Deleting folder {} failed for tree {}", new Object[]{folderId, treeId, e});
                }
            }
        }
        if (!ids.isEmpty()) {
            Connection con = null;
            try {
                con = Database.get(contextId, true);
                con.setAutoCommit(false);
                for (String folderId : ids) {
                    Delete.deleteFolder(contextId, tree, userId, folderId, false, false, con);
                }
                con.commit();
                actionPerformed = true;
            }
            catch (OXException e) {
                DBUtils.rollback(con);
                throw e;
            }
            catch (SQLException e) {
                DBUtils.rollback(con);
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (RuntimeException e) {
                DBUtils.rollback(con);
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            finally {
                if (null != con) {
                    DBUtils.autocommit(con);
                    Database.back(contextId, true, con);
                }
            }
        }
        if (actionPerformed) {
            CacheFolderStorage.getInstance().clearCache(userId, contextId);
        }
        return first;
    }
}

