/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.memory;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.events.CacheEvent;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.folderstorage.cache.CacheServiceRegistry;
import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderMapManagement {
    private static final Logger LOG = LoggerFactory.getLogger(FolderMapManagement.class);
    public static final String REGION = FolderMapManagement.class.getSimpleName();
    private static final FolderMapManagement INSTANCE = new FolderMapManagement();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, FolderMap>> map = new ConcurrentLinkedHashMap.Builder().initialCapacity(64).maximumWeightedCapacity(5000L).weigher(Weighers.entrySingleton()).build();

    public static FolderMapManagement getInstance() {
        return INSTANCE;
    }

    private FolderMapManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(int contextId) {
        this.dropFor(contextId, true);
    }

    public void dropFor(int contextId, boolean notify) {
        this.map.remove(contextId);
        if (notify) {
            FolderMapManagement.fireInvalidateCacheEvent(contextId);
        }
        LOG.debug("Cleaned user-sensitive folder cache for context {}", (Object)contextId);
    }

    public void dropFor(int userId, int contextId) {
        this.dropFor(userId, contextId, true);
    }

    public void dropFor(int userId, int contextId, boolean notify) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null != contextMap) {
            contextMap.remove(userId);
        }
        if (notify) {
            FolderMapManagement.fireInvalidateCacheEvent(userId, contextId);
        }
        LOG.debug("Cleaned user-sensitive folder cache for user {} in context {}", (Object)userId, (Object)contextId);
    }

    public FolderMap getFor(int contextId, int userId) {
        FolderMap newFolderMap;
        Integer us;
        FolderMap folderMap;
        NonBlockingHashMap contextMap = (NonBlockingHashMap)this.map.get(contextId);
        if (null == contextMap) {
            NonBlockingHashMap newMap = new NonBlockingHashMap(256);
            contextMap = this.map.putIfAbsent(contextId, (ConcurrentMap<Integer, FolderMap>)newMap);
            if (null == contextMap) {
                contextMap = newMap;
            }
        }
        if (null == (folderMap = (FolderMap)contextMap.get(us = Integer.valueOf(userId))) && null == (folderMap = contextMap.putIfAbsent(us, newFolderMap = new FolderMap(1024, 300, TimeUnit.SECONDS, userId, contextId)))) {
            folderMap = newFolderMap;
        }
        return folderMap;
    }

    public FolderMap optFor(Session session) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null == contextMap) {
            return null;
        }
        return (FolderMap)contextMap.get(session.getUserId());
    }

    public FolderMap optFor(int userId, int contextId) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null == contextMap) {
            return null;
        }
        return (FolderMap)contextMap.get(userId);
    }

    public void dropFor(String folderId, String treeId, int optUser, int contextId) {
        this.dropFor(folderId, treeId, optUser, contextId, null);
    }

    public void dropFor(String folderId, String treeId, int optUser, int contextId, Session optSession) {
        this.dropFor(folderId, treeId, optUser, contextId, optSession, true);
    }

    public void dropFor(List<String> folderIds, String treeId, int optUser, int contextId, Session optSession) {
        this.dropFor(folderIds, treeId, optUser, contextId, optSession, true);
    }

    public void dropFor(List<String> folderIds, String treeId, int optUser, int contextId, Session optSession, boolean notify) {
        if (null == folderIds || null == treeId) {
            return;
        }
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null == contextMap) {
            return;
        }
        for (String folderId : folderIds) {
            if (optUser > 0 && Tools.getUnsignedInteger(folderId) < 0) {
                FolderMap folderMap = (FolderMap)contextMap.get(optUser);
                if (null == folderMap) continue;
                folderMap.remove(folderId, treeId, optSession);
                continue;
            }
            for (FolderMap folderMap : contextMap.values()) {
                if (null == optSession) {
                    folderMap.remove(folderId, treeId);
                    continue;
                }
                folderMap.remove(folderId, treeId, optSession);
            }
        }
        if (notify) {
            FolderMapManagement.fireInvalidateCacheEvent(folderIds, treeId, optUser, contextId);
        }
    }

    public void dropHierarchyFor(List<String> folderIds, String treeId, int optUser, int contextId) {
        this.dropHierarchyFor(folderIds, treeId, optUser, contextId, true);
    }

    public void dropHierarchyFor(List<String> folderIds, String treeId, int optUser, int contextId, boolean notify) {
        if (null == folderIds || null == treeId) {
            return;
        }
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null == contextMap) {
            return;
        }
        HashSet<String> ids = notify ? new HashSet<String>(16, 0.9f) : null;
        for (String folderId : folderIds) {
            if (optUser > 0 && Tools.getUnsignedInteger(folderId) < 0) {
                FolderMap folderMap = (FolderMap)contextMap.get(optUser);
                if (null == folderMap) continue;
                folderMap.removeHierarchy(folderId, treeId, ids);
                continue;
            }
            for (FolderMap folderMap : contextMap.values()) {
                folderMap.removeHierarchy(folderId, treeId, ids);
            }
        }
        if (notify && null != ids && !ids.isEmpty()) {
            FolderMapManagement.fireInvalidateCacheEvent(new ArrayList<String>(ids), treeId, optUser, contextId);
        }
    }

    public void dropFor(String folderId, String treeId, int optUser, int contextId, Session optSession, boolean notify) {
        if (null == folderId || null == treeId) {
            return;
        }
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null == contextMap) {
            return;
        }
        if (optUser > 0 && Tools.getUnsignedInteger(folderId) < 0) {
            FolderMap folderMap = (FolderMap)contextMap.get(optUser);
            if (null != folderMap) {
                folderMap.remove(folderId, treeId, optSession);
            }
        } else {
            for (FolderMap folderMap : contextMap.values()) {
                if (null == optSession) {
                    folderMap.remove(folderId, treeId);
                    continue;
                }
                folderMap.remove(folderId, treeId, optSession);
            }
        }
        if (notify) {
            FolderMapManagement.fireInvalidateCacheEvent(folderId, treeId, optUser, contextId);
        }
    }

    private static void fireInvalidateCacheEvent(int contextId) {
        FolderMapManagement.fireInvalidateCacheEvent(-1, contextId);
    }

    private static void fireInvalidateCacheEvent(int userId, int contextId) {
        FolderMapManagement.fireInvalidateCacheEvent((String)null, null, userId, contextId);
    }

    private static void fireInvalidateCacheEvent(String folderId, String treeId, int optUser, int contextId) {
        FolderMapManagement.fireInvalidateCacheEvent(Collections.singletonList(folderId), treeId, optUser, contextId);
    }

    private static void fireInvalidateCacheEvent(List<String> folderIds, String treeId, int optUser, int contextId) {
        CacheEventService cacheEventService = (CacheEventService)CacheServiceRegistry.getServiceRegistry().getOptionalService(CacheEventService.class);
        if (null != cacheEventService && cacheEventService.getConfiguration().remoteInvalidationForPersonalFolders()) {
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null == cacheService) {
                return;
            }
            if (null == folderIds || folderIds.isEmpty() || 1 == folderIds.size() && null == folderIds.get(0)) {
                CacheEvent event = CacheEvent.INVALIDATE((String)REGION, (String)String.valueOf(contextId), (Serializable)cacheService.newCacheKey(optUser, new String[0]));
                cacheEventService.notify((Object)INSTANCE, event, false);
            } else {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(treeId);
                for (String folderId : folderIds) {
                    if (Tools.isGlobalId(folderId)) continue;
                    keys.add(folderId);
                }
                if (!keys.isEmpty()) {
                    CacheEvent event = CacheEvent.INVALIDATE((String)REGION, (String)String.valueOf(contextId), (Serializable)cacheService.newCacheKey(optUser, keys.toArray(new String[keys.size()])));
                    cacheEventService.notify((Object)INSTANCE, event, false);
                }
            }
        }
    }
}

