/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical.itip;

import java.util.Locale;

public enum ITipMethod {
    NO_METHOD(""),
    REQUEST("request"),
    REPLY("reply"),
    CANCEL("cancel"),
    COUNTER("counter"),
    DECLINECOUNTER("declinecounter"),
    REFRESH("refresh"),
    ADD("add"),
    PUBLISH("publish");

    private final String keyword;

    private ITipMethod(String keyword) {
        this.keyword = keyword;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getMethod() {
        return "method=" + this.keyword.toUpperCase(Locale.US);
    }

    public static ITipMethod get(String keyword) {
        if (keyword == null) {
            return NO_METHOD;
        }
        if ((keyword = keyword.trim().toLowerCase(Locale.US)).equals(REQUEST.getKeyword())) {
            return REQUEST;
        }
        if (keyword.equals(REPLY.getKeyword())) {
            return REPLY;
        }
        if (keyword.equals(CANCEL.getKeyword())) {
            return CANCEL;
        }
        if (keyword.equals(COUNTER.getKeyword())) {
            return COUNTER;
        }
        if (keyword.equals(DECLINECOUNTER.getKeyword())) {
            return DECLINECOUNTER;
        }
        if (keyword.equals(REFRESH.getKeyword())) {
            return REFRESH;
        }
        if (keyword.equals(ADD.getKeyword())) {
            return ADD;
        }
        if (keyword.equals(PUBLISH.getKeyword())) {
            return PUBLISH;
        }
        return NO_METHOD;
    }
}

