/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.context.osgi;

import com.openexchange.context.mbean.ContextMBean;
import com.openexchange.context.mbean.ContextMBeanImpl;
import com.openexchange.database.CreateTableService;
import com.openexchange.database.DatabaseService;
import com.openexchange.groupware.contexts.impl.sql.ContextAttributeCreateTable;
import com.openexchange.groupware.contexts.impl.sql.ContextAttributeTableUpdateTask;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.management.ManagementService;
import com.openexchange.management.Managements;
import com.openexchange.osgi.HousekeepingActivator;
import java.util.Arrays;
import java.util.Collection;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextActivator
extends HousekeepingActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{DatabaseService.class};
    }

    protected void startBundle() throws Exception {
        final Logger logger = LoggerFactory.getLogger(ContextActivator.class);
        DatabaseService dbase = (DatabaseService)this.getService(DatabaseService.class);
        ContextAttributeCreateTable createTable = new ContextAttributeCreateTable();
        this.registerService(CreateTableService.class, (Object)createTable);
        final ContextAttributeTableUpdateTask updateTask = new ContextAttributeTableUpdateTask(dbase);
        this.registerService(UpdateTaskProviderService.class, new UpdateTaskProviderService(){

            @Override
            public Collection<? extends UpdateTaskV2> getUpdateTasks() {
                return Arrays.asList(updateTask);
            }
        });
        final BundleContext context = this.context;
        this.track(ManagementService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ManagementService, ManagementService>(){

            public ManagementService addingService(ServiceReference<ManagementService> reference) {
                ManagementService service = (ManagementService)context.getService(reference);
                try {
                    ObjectName objectName = Managements.getObjectName((String)ContextMBean.class.getName(), (String)"com.openexchange.context");
                    service.registerMBean(objectName, (Object)new ContextMBeanImpl());
                    return service;
                }
                catch (Exception e) {
                    logger.warn("Could not register MBean '{}'", (Object)ContextMBean.class.getName());
                    context.ungetService(reference);
                    return null;
                }
            }

            public void modifiedService(ServiceReference<ManagementService> reference, ManagementService service) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<ManagementService> reference, ManagementService service) {
                if (null != service) {
                    try {
                        service.unregisterMBean(Managements.getObjectName((String)ContextMBean.class.getName(), (String)"com.openexchange.context"));
                    }
                    catch (Exception e) {
                        logger.warn("Unregistering MBean '{}' failed.", (Object)ContextMBean.class.getName(), (Object)e);
                    }
                    finally {
                        context.ungetService(reference);
                    }
                }
            }
        });
        this.openTrackers();
    }

    protected void stopBundle() throws Exception {
        super.stopBundle();
    }
}

