/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency.solver;

import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.consistency.Entity;
import com.openexchange.consistency.solver.ProblemSolver;
import com.openexchange.exception.OXException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBrokenPreviewReferencesSolver
implements ProblemSolver {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteBrokenPreviewReferencesSolver.class);

    @Override
    public void solve(Entity entity, Set<String> problems) throws OXException {
        if (entity.getType().equals((Object)Entity.EntityType.Context) && problems.size() > 0) {
            ResourceCacheMetadataStore metadataStore = ResourceCacheMetadataStore.getInstance();
            metadataStore.removeByRefId(entity.getContext().getContextId(), problems);
            LOG.info("Deleted {} broken preview cache references.", (Object)problems.size());
        }
    }

    @Override
    public String description() {
        return "delete broken preview references";
    }
}

