/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.group.Group;
import com.openexchange.java.Strings;
import com.openexchange.tools.TimeZoneUtils;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupWriter
extends DataWriter {
    private final TimeZone utc = TimeZoneUtils.getTimeZone("utc");

    public GroupWriter() {
        super(null, null);
    }

    public void writeArray(Group group, JSONArray json, List<Group.Field> fields) {
        for (Group.Field field : fields) {
            if (field == Group.Field.MEMBERS) {
                json.put((Object)Strings.join((int[])group.getMember(), (String)","));
                continue;
            }
            json.put(group.get(field));
        }
    }

    public void writeGroup(Group group, JSONObject json) throws JSONException {
        GroupWriter.writeParameter("id", group.getIdentifier(), json);
        GroupWriter.writeParameter("display_name", group.getDisplayName(), json);
        GroupWriter.writeParameter("name", group.getSimpleName(), json);
        GroupWriter.writeParameter("last_modified_utc", group.getLastModified(), this.utc, json);
        this.writeMembers(group, json);
    }

    protected void writeMembers(Group group, JSONObject json) throws JSONException {
        int[] members = group.getMember();
        if (null == members) {
            json.put("members", (Object)new JSONArray(0));
        } else {
            JSONArray jsonArray = new JSONArray(members.length);
            for (int member : members) {
                jsonArray.put(member);
            }
            json.put("members", (Object)jsonArray);
        }
    }
}

