/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.fileholder.Readable;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.responseRenderers.AbstractListenerCollectingResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.CheckParametersAction;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IDataWrapper;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IFileResponseRendererAction;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.OutputBinaryContentAction;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.PrepareResponseHeaderAction;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.RemovePragmaHeaderAction;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.SetBinaryInputStreamAction;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.TransformImageAction;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.UpdateETagHeaderAction;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.PropertyEvent;
import com.openexchange.config.PropertyListener;
import com.openexchange.imagetransformation.ImageTransformationService;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.http.Tools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResponseRenderer
extends AbstractListenerCollectingResponseRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(FileResponseRenderer.class);
    private static final String SAVE_AS_TYPE = "application/octet-stream";
    private final AtomicReference<File> tmpDirReference;
    private final TransformImageAction imageAction = new TransformImageAction();
    private final List<IFileResponseRendererAction> registeredActions = new ArrayList<IFileResponseRendererAction>(8);

    public FileResponseRenderer() {
        this.registeredActions.add(new CheckParametersAction());
        this.registeredActions.add(this.imageAction);
        this.registeredActions.add(new SetBinaryInputStreamAction());
        this.registeredActions.add(new PrepareResponseHeaderAction());
        this.registeredActions.add(new RemovePragmaHeaderAction());
        this.registeredActions.add(new UpdateETagHeaderAction());
        this.registeredActions.add(new OutputBinaryContentAction());
        final AtomicReference<File> tmpDirReference = new AtomicReference<File>();
        this.tmpDirReference = tmpDirReference;
        ServerServiceRegistry registry = ServerServiceRegistry.getInstance();
        ConfigurationService cs = registry.getService(ConfigurationService.class);
        if (null == cs) {
            throw new IllegalStateException("Missing configuration service");
        }
        String path = cs.getProperty("UPLOAD_DIRECTORY", new PropertyListener(){

            public void onPropertyChange(PropertyEvent event) {
                if (PropertyEvent.Type.CHANGED.equals((Object)event.getType())) {
                    tmpDirReference.set(FileResponseRenderer.getTmpDirByPath(event.getValue()));
                }
            }
        });
        tmpDirReference.set(FileResponseRenderer.getTmpDirByPath(path));
    }

    @Override
    public int getRanking() {
        return 0;
    }

    public void setScaler(ImageTransformationService scaler) {
        this.imageAction.setScaler(scaler);
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof IFileHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualWrite(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        IFileHolder file = (IFileHolder)result.getResultObject();
        if (file == null || this.hasNoFileItem(file)) {
            try {
                resp.sendError(404);
            }
            catch (IOException e) {
                LOG.error("Exception while trying to write HTTP response.", (Throwable)e);
            }
            return;
        }
        try {
            this.writeFileHolder(file, request, result, req, resp);
        }
        finally {
            this.postProcessingTasks(file);
        }
    }

    private void postProcessingTasks(IFileHolder file) {
        List tasks2 = file.getPostProcessingTasks();
        if (null != tasks2 && !tasks2.isEmpty()) {
            for (Runnable task : tasks2) {
                task.run();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void writeFileHolder(IFileHolder fileHolder, AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getContentTypeByFileName(String fileName) {
        return null == fileName ? null : MimeType2ExtMap.getContentType(fileName, null);
    }

    private void sendErrorSafe(int sc, String msg, HttpServletResponse resp) {
        try {
            Tools.sendErrorPage(resp, sc, msg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private boolean hasNoFileItem(IFileHolder file) {
        String fileMIMEType = file.getContentType();
        return (Strings.isEmpty((String)fileMIMEType) || SAVE_AS_TYPE.equals(fileMIMEType)) && Strings.isEmpty((String)file.getName()) && file.getLength() <= 0L;
    }

    static File getTmpDirByPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("Path is null. Probably property \"UPLOAD_DIRECTORY\" is not set.");
        }
        File tmpDir = new File(path);
        if (!tmpDir.exists()) {
            if (!tmpDir.mkdirs()) {
                throw new IllegalArgumentException("Directory " + path + " does not exist and cannot be created.");
            }
            LOG.info("Directory " + path + " did not exist, but could be created.");
        }
        if (!tmpDir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory.");
        }
        return tmpDir;
    }

    public static class FileResponseRendererActionException
    extends Exception {
        private static final long serialVersionUID = 1654135178706909163L;
        public final int statusCode;
        public final String message;

        public FileResponseRendererActionException(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }
    }

    private class DataWrapper
    implements IDataWrapper {
        private String delivery = null;
        private String contentType = null;
        private String contentDisposition = null;
        private String userAgent;
        private String fileContentType;
        private String fileName;
        private long length = -1L;
        private Boolean contentTypeByParameter = Boolean.FALSE;
        private Readable documentData = null;
        private IFileHolder file;
        private HttpServletRequest request;
        private HttpServletResponse response;
        private AJAXRequestData requestData;
        private AJAXRequestResult result;
        private List<Closeable> closeables;
        private AtomicReference<File> tmpDirReference;

        DataWrapper() {
        }

        @Override
        public String getDelivery() {
            return this.delivery;
        }

        @Override
        public IDataWrapper setDelivery(String delivery) {
            this.delivery = delivery;
            return this;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public IDataWrapper setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public IDataWrapper setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public Boolean getContentTypeByParameter() {
            return this.contentTypeByParameter;
        }

        @Override
        public IDataWrapper setContentTypeByParameter(Boolean contentTypeByParameter) {
            this.contentTypeByParameter = contentTypeByParameter;
            return this;
        }

        @Override
        public Readable getDocumentData() {
            return this.documentData;
        }

        @Override
        public IDataWrapper setDocumentData(Readable documentData) {
            this.documentData = documentData;
            return this;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public IDataWrapper setLength(long length) {
            this.length = length;
            return this;
        }

        @Override
        public IFileHolder getFile() {
            return this.file;
        }

        @Override
        public IDataWrapper setFile(IFileHolder file) {
            this.file = file;
            return this;
        }

        @Override
        public HttpServletRequest getRequest() {
            return this.request;
        }

        @Override
        public IDataWrapper setRequest(HttpServletRequest req) {
            this.request = req;
            return this;
        }

        @Override
        public String getFileContentType() {
            return this.fileContentType;
        }

        @Override
        public IDataWrapper setFileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public IDataWrapper setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public AJAXRequestData getRequestData() {
            return this.requestData;
        }

        @Override
        public IDataWrapper setRequestData(AJAXRequestData requestData) {
            this.requestData = requestData;
            return this;
        }

        @Override
        public HttpServletResponse getResponse() {
            return this.response;
        }

        @Override
        public IDataWrapper setResponse(HttpServletResponse response) {
            this.response = response;
            return this;
        }

        @Override
        public String getUserAgent() {
            return this.userAgent;
        }

        @Override
        public IDataWrapper setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public void addCloseable(Closeable closeable) {
            if (this.closeables == null) {
                this.closeables = new ArrayList<Closeable>();
            }
            this.closeables.add(closeable);
        }

        @Override
        public IDataWrapper setCloseAbles(List<Closeable> closeables) {
            if (closeables != null) {
                this.closeables = closeables;
            }
            return this;
        }

        @Override
        public List<Closeable> getCloseables() {
            return this.closeables;
        }

        @Override
        public AJAXRequestResult getResult() {
            return this.result;
        }

        @Override
        public IDataWrapper setResult(AJAXRequestResult result) {
            this.result = result;
            return this;
        }

        @Override
        public AtomicReference<File> getTmpDirReference() {
            return this.tmpDirReference;
        }

        @Override
        public IDataWrapper setTmpDirReference(AtomicReference<File> tmpDirReference) {
            this.tmpDirReference = tmpDirReference;
            return this;
        }
    }
}

