/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.TmpFileFileHolder;
import com.openexchange.ajax.fileholder.ByteArrayRandomAccess;
import com.openexchange.ajax.fileholder.FileRandomAccess;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.fileholder.InputStreamReadable;
import com.openexchange.ajax.fileholder.Readable;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.java.UnsynchronizedByteArrayOutputStream;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import javax.mail.util.SharedFileInputStream;
import jonelo.jacksum.util.Service;

public final class ThresholdFileHolder
implements IFileHolder {
    public static final int DEFAULT_IN_MEMORY_THRESHOLD = 512000;
    private ByteArrayOutputStream buf;
    private long count;
    private File tempFile;
    private String name;
    private String contentType;
    private String disposition;
    private String delivery;
    private final int threshold;
    private final int initalCapacity;
    private final List<Runnable> tasks;
    private final boolean autoManaged;
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ThresholdFileHolder() {
        this(-1, -1);
    }

    public ThresholdFileHolder(boolean autoManaged) {
        this(-1, -1, autoManaged);
    }

    public ThresholdFileHolder(int threshold) {
        this(threshold, -1);
    }

    public ThresholdFileHolder(int threshold, int initalCapacity) {
        this(threshold, initalCapacity, true);
    }

    public ThresholdFileHolder(int threshold, int initalCapacity, boolean autoManaged) {
        this.autoManaged = autoManaged;
        this.count = 0L;
        this.threshold = threshold > 0 ? threshold : 512000;
        this.contentType = "application/octet-stream";
        this.initalCapacity = initalCapacity > 0 ? initalCapacity : 65536;
        this.tasks = new LinkedList<Runnable>();
    }

    public ThresholdFileHolder(IFileHolder source) throws OXException {
        this();
        this.write(source.getStream());
        this.name = source.getName();
        this.contentType = source.getContentType();
        this.delivery = source.getDelivery();
        this.disposition = source.getDisposition();
    }

    public void reset() {
        ByteArrayOutputStream baos;
        File tempFile = this.tempFile;
        if (null != tempFile) {
            tempFile.delete();
            this.tempFile = null;
        }
        if (null != (baos = this.buf)) {
            baos.reset();
        }
    }

    public ByteArrayOutputStream getBuffer() {
        return this.buf;
    }

    public boolean isInMemory() {
        return null == this.tempFile && this.buf != null;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public OutputStream asOutputStream() {
        return new TransferringOutStream(this);
    }

    public ThresholdFileHolder write(byte[] bytes, int off, int len) throws OXException {
        if (bytes == null) {
            return this;
        }
        if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        return this.write((InputStream)new UnsynchronizedByteArrayInputStream(bytes, off, len));
    }

    public ThresholdFileHolder write(byte[] bytes) throws OXException {
        block5: {
            File tempFile;
            if (bytes == null) {
                return this;
            }
            if (null != this.tempFile || null != this.buf || bytes.length <= this.threshold) break block5;
            this.tempFile = tempFile = TmpFileFileHolder.newTempFile(this.autoManaged);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(tempFile);
                ((OutputStream)out).write(bytes, 0, bytes.length);
                out.flush();
            }
            catch (IOException e) {
                try {
                    throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    Streams.close(out);
                    throw throwable;
                }
            }
            Streams.close((Closeable)out);
            return this;
        }
        return this.write(Streams.newByteArrayInputStream((byte[])bytes));
    }

    public ThresholdFileHolder write(InputStream in) throws OXException {
        if (null == in) {
            return this;
        }
        return this.write((Readable)new InputStreamReadable(in));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ThresholdFileHolder write(Readable in) throws OXException {
        if (null == in) {
            return this;
        }
        OutputStream out = null;
        try {
            File tempFile = this.tempFile;
            long count = this.count;
            if (null == tempFile) {
                int len;
                ByteArrayOutputStream baos = this.buf;
                if (null == baos) {
                    this.buf = baos = Streams.newByteArrayOutputStream((int)this.initalCapacity);
                }
                out = baos;
                int inMemoryThreshold = this.threshold;
                int buflen = 65535;
                byte[] buffer = new byte[65535];
                while ((len = in.read(buffer, 0, 65535)) > 0) {
                    if (null == tempFile && (count += (long)len) > (long)inMemoryThreshold) {
                        this.tempFile = tempFile = TmpFileFileHolder.newTempFile(this.autoManaged);
                        out = new FileOutputStream(tempFile);
                        baos.writeTo(out);
                        baos = null;
                        this.buf = null;
                    }
                    out.write(buffer, 0, len);
                }
                out.flush();
            } else {
                int len;
                out = new FileOutputStream(tempFile, true);
                int buflen = 65535;
                byte[] buffer = new byte[65535];
                while ((len = in.read(buffer, 0, 65535)) > 0) {
                    count += (long)len;
                    out.write(buffer, 0, len);
                }
                out.flush();
            }
            this.count = count;
        }
        catch (IOException e) {
            try {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Streams.close((Closeable)in);
                Streams.close(out);
                throw throwable;
            }
        }
        Streams.close((Closeable)in);
        Streams.close((Closeable)out);
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMD5() throws OXException {
        File tempFile = this.tempFile;
        if (null != tempFile) {
            String string;
            DigestInputStream digestStream = null;
            try {
                int read;
                digestStream = new DigestInputStream(new FileInputStream(tempFile), MessageDigest.getInstance("MD5"));
                byte[] buf = new byte[8192];
                while ((read = digestStream.read(buf, 0, 8192)) > 0) {
                }
                byte[] digest = digestStream.getMessageDigest().digest();
                string = Service.format((byte[])digest);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                    catch (IOException e2) {
                        throw AjaxExceptionCodes.IO_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Streams.close(digestStream);
                    throw throwable;
                }
            }
            Streams.close((Closeable)digestStream);
            return string;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(Streams.stream2bytes((InputStream)this.getStream()));
            return Service.format((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    public long getCount() {
        return this.count;
    }

    public boolean repetitive() {
        return true;
    }

    public void close() {
        File tempFile = this.tempFile;
        if (null != tempFile) {
            tempFile.delete();
            this.tempFile = null;
        }
        this.buf = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeTo(OutputStream out) throws OXException {
        block10: {
            ByteArrayOutputStream buf;
            block9: {
                if (this.count <= 0L) {
                    return;
                }
                buf = this.buf;
                if (null != buf) break block9;
                File tempFile = this.tempFile;
                if (null == tempFile) {
                    IOException e = new IOException("Already closed.");
                    throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
                }
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(tempFile);
                    int buflen = 65535;
                    byte[] buffer = new byte[65535];
                    while ((len = ((InputStream)in).read(buffer, 0, 65535)) > 0) {
                        out.write(buffer, 0, len);
                    }
                }
                catch (IOException e) {
                    try {
                        throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Streams.close(in);
                        throw throwable;
                    }
                }
                Streams.close((Closeable)in);
                break block10;
            }
            try {
                buf.writeTo(out);
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
    }

    public byte[] toByteArray() throws OXException {
        byte[] byArray;
        if (this.count <= 0L) {
            return new byte[0];
        }
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return buf.toByteArray();
        }
        File tempFile = this.tempFile;
        if (null == tempFile) {
            IOException e = new IOException("Already closed.");
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        FileInputStream in = null;
        try {
            int len;
            in = new FileInputStream(tempFile);
            ByteArrayOutputStream baos = Streams.newByteArrayOutputStream((int)((InputStream)in).available());
            int buflen = 65535;
            byte[] buffer = new byte[65535];
            while ((len = ((InputStream)in).read(buffer, 0, 65535)) > 0) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(in);
                throw throwable;
            }
        }
        Streams.close((Closeable)in);
        return byArray;
    }

    public ThresholdFileHolder copy() throws OXException {
        ThresholdFileHolder copy = new ThresholdFileHolder();
        copy.count = this.count;
        copy.contentType = this.contentType;
        copy.delivery = this.delivery;
        copy.disposition = this.disposition;
        copy.name = this.name;
        if (this.count <= 0L) {
            return copy;
        }
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            copy.buf = new UnsynchronizedByteArrayOutputStream(buf);
        } else if (null != this.tempFile) {
            try {
                File newTempFile = TmpFileFileHolder.newTempFile(this.autoManaged);
                ThresholdFileHolder.copyFile(this.tempFile, newTempFile);
                copy.tempFile = newTempFile;
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        return copy;
    }

    public InputStream getClosingStream() throws OXException {
        return new ClosingInputStream(this);
    }

    public InputStream getStream() throws OXException {
        if (this.count <= 0L) {
            return Streams.EMPTY_INPUT_STREAM;
        }
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return Streams.asInputStream((ByteArrayOutputStream)buf);
        }
        File tempFile = this.tempFile;
        if (null == tempFile) {
            IOException e = new IOException("Already closed.");
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        try {
            return new FileInputStream(tempFile);
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    public IFileHolder.RandomAccess getClosingRandomAccess() throws OXException {
        return new ClosingRandomAccess(this);
    }

    public IFileHolder.RandomAccess getRandomAccess() throws OXException {
        if (this.count <= 0L) {
            return new ByteArrayRandomAccess(new byte[0]);
        }
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return new ByteArrayRandomAccess(buf.toByteArray());
        }
        File tempFile = this.tempFile;
        if (null != tempFile) {
            try {
                return new FileRandomAccess(tempFile);
            }
            catch (FileNotFoundException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        return null;
    }

    public SharedInputStream getSharedStream() throws IOException {
        if (this.count <= 0L) {
            return new SharedByteArrayInputStream(new byte[0]);
        }
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return new SharedByteArrayInputStream(buf.toByteArray());
        }
        File tempFile = this.tempFile;
        if (null == tempFile) {
            throw new IOException("Already closed.");
        }
        return new SharedFileInputStream(tempFile);
    }

    public long getLength() {
        if (this.count <= 0L) {
            return 0L;
        }
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return buf.size();
        }
        File tempFile = this.tempFile;
        if (null == tempFile) {
            throw new IllegalStateException("Already closed.");
        }
        return tempFile.length();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getDelivery() {
        return this.delivery;
    }

    public ThresholdFileHolder setContentInfo(IFileHolder fileHolder) {
        if (null != fileHolder) {
            this.setContentType(fileHolder.getContentType());
            this.setDelivery(fileHolder.getDelivery());
            this.setDisposition(fileHolder.getDisposition());
            this.setName(fileHolder.getName());
        }
        return this;
    }

    public List<Runnable> getPostProcessingTasks() {
        return this.tasks;
    }

    public void addPostProcessingTask(Runnable task) {
        if (null != task) {
            this.tasks.add(task);
        }
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    private static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{inChannel, outChannel});
                throw throwable;
            }
        }
        Streams.close((Closeable[])new Closeable[]{inChannel, outChannel});
    }

    public static String md5Encode(byte[] binaryData) {
        if (null == binaryData || binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i << 1] = hexadecimal[high];
            buffer[(i << 1) + 1] = hexadecimal[low];
        }
        return new String(buffer);
    }

    private static final class ClosingRandomAccess
    implements IFileHolder.RandomAccess {
        private final ThresholdFileHolder fileHolder;
        private final IFileHolder.RandomAccess randomAccess;

        protected ClosingRandomAccess(ThresholdFileHolder fileHolder) throws OXException {
            this.fileHolder = fileHolder;
            this.randomAccess = fileHolder.getRandomAccess();
        }

        public int read(byte[] b) throws IOException {
            return this.randomAccess.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.randomAccess.read(b, off, len);
        }

        public void seek(long pos) throws IOException {
            this.randomAccess.seek(pos);
        }

        public long length() throws IOException {
            return this.randomAccess.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.randomAccess.close();
            }
            finally {
                this.fileHolder.close();
            }
        }
    }

    private static final class ClosingInputStream
    extends FilterInputStream {
        private final ThresholdFileHolder fileHolder;

        protected ClosingInputStream(ThresholdFileHolder fileHolder) throws OXException {
            super(fileHolder.getStream());
            this.fileHolder = fileHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.fileHolder.close();
            }
        }
    }

    private static final class TransferringOutStream
    extends OutputStream {
        private final ThresholdFileHolder fileHolder;

        TransferringOutStream(ThresholdFileHolder fileHolder) {
            this.fileHolder = fileHolder;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.fileHolder.write(new byte[]{(byte)b});
            }
            catch (OXException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.fileHolder.write(b, off, len);
            }
            catch (OXException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
        }
    }
}

