/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.TaskWriter;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.TimeZones;
import java.io.StringWriter;
import java.io.Writer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TaskWriterTest {
    @Test
    public void testWriteTaskPriority() throws JSONException {
        Task task = new Task();
        task.setPriority(Autoboxing.I((int)0));
        JSONObject json = new JSONObject();
        new TaskWriter(TimeZones.UTC).writeTask(task, json);
        Assert.assertTrue((String)"Task priority was not written.", (boolean)json.has("priority"));
        StringWriter sw = new StringWriter();
        json.write((Writer)sw);
        Assert.assertThat((String)"Task priority was not written as expected.", (Object)sw.toString(), (Matcher)CoreMatchers.containsString((String)"\"priority\":0"));
    }

    @Test
    public void testWriteTaskPriorityNull() throws JSONException {
        Task task = new Task();
        task.setPriority(null);
        JSONObject json = new JSONObject();
        new TaskWriter(TimeZones.UTC).writeTask(task, json);
        StringWriter sw = new StringWriter();
        json.write((Writer)sw);
        Assert.assertThat((String)"Task priority should not be written.", (Object)sw.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"priority")));
        Assert.assertFalse((String)"Task priority should not be written.", (boolean)json.has("priority"));
    }

    @Test
    public void testWriteTaskArrayPriority() throws JSONException {
        Task task = new Task();
        task.setPriority(Autoboxing.I((int)0));
        JSONArray tmp = new JSONArray();
        new TaskWriter(TimeZones.UTC).writeArray(task, new int[]{309}, tmp);
        JSONArray json = tmp.getJSONArray(0);
        Assert.assertEquals((String)"Written array should contain exactly and only written priority.", (long)1L, (long)json.length());
        StringWriter sw = new StringWriter();
        json.write((Writer)sw);
        Assert.assertEquals((String)"Written json array does not look like expected.", (Object)"[0]", (Object)sw.toString());
    }

    @Test
    public void testWriteTaskArrayPriorityNull() throws JSONException {
        Task task = new Task();
        task.setPriority(null);
        JSONArray tmp = new JSONArray();
        new TaskWriter(TimeZones.UTC).writeArray(task, new int[]{309}, tmp);
        JSONArray json = tmp.getJSONArray(0);
        Assert.assertEquals((String)"Written array should contain exactly and only written priority.", (long)1L, (long)json.length());
        StringWriter sw = new StringWriter();
        json.write((Writer)sw);
        Assert.assertEquals((String)"Written json array does not look like expected.", (Object)"[null]", (Object)sw.toString());
    }
}

