/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.converters.preview.cache.FileStoreResourceCacheImpl;
import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorage;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FileStoreResourceCacheImpl.class, ServerServiceRegistry.class})
public class FileStoreResourceCacheImplTest {
    @Test
    public void testFileIsDeletedOnDataTruncation() throws Exception {
        this.testFileIsDeletedOnRollback(DataTruncation.class);
    }

    @Test
    public void testFileIsDeletedOnSqlException() throws Exception {
        this.testFileIsDeletedOnRollback(SQLException.class);
    }

    private void testFileIsDeletedOnRollback(Class<? extends Exception> exceptionClass) throws Exception {
        PreparedStatement statement = (PreparedStatement)PowerMockito.mock(PreparedStatement.class);
        PowerMockito.when((Object)statement.executeUpdate()).thenThrow(new Class[]{exceptionClass});
        PowerMockito.when((Object)statement.executeQuery()).thenReturn(PowerMockito.mock(ResultSet.class));
        Connection connection = (Connection)PowerMockito.mock(Connection.class);
        PowerMockito.when((Object)connection.prepareStatement(Matchers.anyString())).thenReturn((Object)statement);
        PowerMockito.when((Object)connection.createStatement()).thenReturn(PowerMockito.mock(Statement.class));
        DatabaseService databaseService = (DatabaseService)PowerMockito.mock(DatabaseService.class);
        PowerMockito.when((Object)databaseService.getWritable(Matchers.anyInt())).thenReturn((Object)connection);
        ConfigurationService configMock = (ConfigurationService)PowerMockito.mock(ConfigurationService.class);
        PowerMockito.when((Object)configMock.getProperty(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"-1");
        ServiceLookup serviceLookupMock = (ServiceLookup)PowerMockito.mock(ServiceLookup.class);
        PowerMockito.when((Object)serviceLookupMock.getService(DatabaseService.class)).thenReturn((Object)databaseService);
        PowerMockito.when((Object)serviceLookupMock.getService(ConfigurationService.class)).thenReturn((Object)configMock);
        FileStoreResourceCacheImpl cache = (FileStoreResourceCacheImpl)PowerMockito.spy((Object)new FileStoreResourceCacheImpl(serviceLookupMock));
        PowerMockito.mockStatic(FileStoreResourceCacheImpl.class, (Class[])new Class[0]);
        FileStorage fileStorage = (FileStorage)PowerMockito.mock(FileStorage.class);
        String fileId = "12345";
        PowerMockito.when((Object)fileStorage.saveNewFile((InputStream)Matchers.any(InputStream.class))).thenReturn((Object)fileId);
        PowerMockito.when(FileStoreResourceCacheImpl.class, (String)"getFileStorage", (Object[])new Object[]{Matchers.anyInt(), Matchers.anyBoolean()}).thenReturn((Object)fileStorage);
        boolean exceptionThrown = false;
        try {
            byte[] bytes = new byte[100];
            CachedResource resource = new CachedResource(bytes, "some_image.jpg", "image/jpeg", 100L);
            cache.save("resource-id", resource, 1, 1);
        }
        catch (OXException e) {
            exceptionThrown = true;
            Assert.assertTrue((boolean)exceptionClass.isInstance(e.getCause()));
        }
        Assert.assertTrue((boolean)exceptionThrown);
        ((DatabaseService)Mockito.verify((Object)databaseService, (VerificationMode)Mockito.times((int)1))).getWritable(Matchers.anyInt());
        InOrder autoCommitOrder = Mockito.inOrder((Object[])new Object[]{connection});
        ((Connection)autoCommitOrder.verify((Object)connection)).setAutoCommit(false);
        ((Connection)autoCommitOrder.verify((Object)connection)).setAutoCommit(true);
        ((Connection)Mockito.verify((Object)connection)).prepareStatement(Matchers.startsWith((String)"INSERT INTO"));
        ((PreparedStatement)Mockito.verify((Object)statement)).executeUpdate();
        ((Connection)Mockito.verify((Object)connection)).rollback();
        ((FileStorage)Mockito.verify((Object)fileStorage)).deleteFile(fileId);
    }
}

