/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Charsets;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.java.UnsynchronizedByteArrayOutputStream;
import com.openexchange.java.UnsynchronizedStringReader;
import com.openexchange.java.UnsynchronizedStringWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;

public class Streams {
    public static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int available() {
            return 0;
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return -1;
        }
    };
    public static final OutputStream EMPTY_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    };

    private Streams() {
    }

    public static InputStream getNonEmpty(InputStream is) throws IOException {
        if (null == is) {
            return null;
        }
        PushbackInputStream pis = new PushbackInputStream(is);
        int check = pis.read();
        if (check < 0) {
            Streams.close((Closeable)pis);
            return null;
        }
        pis.unread(check);
        return pis;
    }

    public static InputStream bufferedInputStreamFor(InputStream in) {
        if (null == in) {
            return in;
        }
        if (in instanceof BufferedInputStream || in instanceof ByteArrayInputStream) {
            return in;
        }
        return new BufferedInputStream(in, 65536);
    }

    public static OutputStream bufferedOutputStreamFor(OutputStream out) {
        if (null == out) {
            return out;
        }
        if (out instanceof BufferedOutputStream || out instanceof ByteArrayOutputStream) {
            return out;
        }
        return new BufferedOutputStream(out, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stream2string(InputStream is, String charset) throws IOException {
        if (null == is) {
            return null;
        }
        try {
            int read;
            UnsynchronizedByteArrayOutputStream bos = new UnsynchronizedByteArrayOutputStream(4096);
            int buflen = 2048;
            byte[] buf = new byte[buflen];
            while ((read = is.read(buf, 0, buflen)) > 0) {
                bos.write(buf, 0, read);
            }
            String string = bos.toString(Charsets.forName(charset));
            return string;
        }
        finally {
            Streams.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader2string(Reader reader) throws IOException {
        if (null == reader) {
            return null;
        }
        try {
            int read;
            StringBuilder builder = new StringBuilder(8192);
            int buflen = 2048;
            char[] cbuf = new char[buflen];
            while ((read = reader.read(cbuf, 0, buflen)) > 0) {
                builder.append(cbuf, 0, read);
            }
            String string = 0 == builder.length() ? null : builder.toString();
            return string;
        }
        finally {
            Streams.close((Closeable)reader);
        }
    }

    public static ByteArrayInputStream asInputStream(ByteArrayOutputStream baos) {
        if (null == baos) {
            return null;
        }
        if (baos instanceof UnsynchronizedByteArrayOutputStream) {
            return ((UnsynchronizedByteArrayOutputStream)baos).toByteArrayInputStream();
        }
        return new UnsynchronizedByteArrayInputStream(baos.toByteArray());
    }

    public static ByteArrayInputStream asInputStream(InputStream in) throws IOException {
        if (null == in) {
            return null;
        }
        return Streams.newByteArrayInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream stream2ByteArrayOutputStream(InputStream is) throws IOException {
        if (null == is) {
            return null;
        }
        try {
            int read;
            ByteArrayOutputStream bos = Streams.newByteArrayOutputStream(4096);
            int buflen = 2048;
            byte[] buf = new byte[2048];
            while ((read = is.read(buf, 0, 2048)) > 0) {
                bos.write(buf, 0, read);
            }
            ByteArrayOutputStream byteArrayOutputStream = bos;
            return byteArrayOutputStream;
        }
        finally {
            Streams.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] stream2bytes(InputStream is) throws IOException {
        if (null == is) {
            return new byte[0];
        }
        if (is instanceof UnsynchronizedByteArrayInputStream) {
            UnsynchronizedByteArrayInputStream ubais = (UnsynchronizedByteArrayInputStream)is;
            byte[] buf = ubais.getBuf();
            int pos = ubais.getPosition();
            int len = ubais.getCount() - pos;
            byte[] newbuf = new byte[len];
            System.arraycopy(buf, pos, newbuf, 0, len);
            return newbuf;
        }
        try {
            int read;
            ByteArrayOutputStream bos = Streams.newByteArrayOutputStream(4096);
            int buflen = 2048;
            byte[] buf = new byte[2048];
            while ((read = is.read(buf, 0, 2048)) > 0) {
                bos.write(buf, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            Streams.close((Closeable)is);
        }
    }

    public static Reader newStringReader(String s) {
        return null == s ? null : new UnsynchronizedStringReader(s);
    }

    public static Writer newStringWriter() {
        return new UnsynchronizedStringWriter(32);
    }

    public static Writer newStringWriter(int initial) {
        return new UnsynchronizedStringWriter(initial);
    }

    public static ByteArrayOutputStream newByteArrayOutputStream() {
        return new UnsynchronizedByteArrayOutputStream(32);
    }

    public static ByteArrayOutputStream newByteArrayOutputStream(int capacity) {
        return new UnsynchronizedByteArrayOutputStream(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayInputStream newByteArrayInputStream(InputStream inputStream) throws IOException {
        try {
            int read;
            UnsynchronizedByteArrayOutputStream bos = new UnsynchronizedByteArrayOutputStream(4096);
            int buflen = 2048;
            byte[] buf = new byte[2048];
            while ((read = inputStream.read(buf, 0, 2048)) > 0) {
                bos.write(buf, 0, read);
            }
            ByteArrayInputStream byteArrayInputStream = bos.toByteArrayInputStream();
            return byteArrayInputStream;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    public static ByteArrayInputStream newByteArrayInputStream(byte[] bytes) {
        return new UnsynchronizedByteArrayInputStream(bytes);
    }

    public static ByteArrayInputStream newByteArrayInputStream(byte[] bytes, int offset, int length) {
        return new UnsynchronizedByteArrayInputStream(bytes, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countInputStream(InputStream in) throws IOException {
        if (null == in) {
            return 0L;
        }
        try {
            int read;
            int blen = 2048;
            byte[] buf = new byte[2048];
            long count = 0L;
            while ((read = in.read(buf, 0, 2048)) > 0) {
                count += (long)read;
            }
            long l = count;
            return l;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static void close(Closeable toClose) {
        if (null != toClose) {
            try {
                toClose.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable ... closeables) {
        if (null != closeables) {
            for (Closeable toClose : closeables) {
                if (null == toClose) continue;
                try {
                    toClose.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static void close(Collection<? extends Closeable> closeables) {
        if (null != closeables) {
            for (Closeable closeable : closeables) {
                if (null == closeable) continue;
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void flush(Flushable toFlush) {
        if (null != toFlush) {
            try {
                toFlush.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static PushbackInputStream pushbackInputStreamFor(InputStream in) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAscii(InputStream in) throws IOException {
        if (null == in) {
            return true;
        }
        try {
            int read;
            boolean isAscci = true;
            int buflen = 2048;
            byte[] buf = new byte[buflen];
            while (isAscci && (read = in.read(buf, 0, buflen)) > 0) {
                int i = read;
                while (isAscci && i-- > 0) {
                    isAscci = buf[i] >= 0;
                }
            }
            boolean bl = isAscci;
            return bl;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static boolean isAscii(byte[] bytes) {
        boolean isAscci = true;
        if (null != bytes) {
            int i = bytes.length;
            while (isAscci && i-- > 0) {
                isAscci = bytes[i] >= 0;
            }
        }
        return isAscci;
    }
}

