/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchIterators {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchIterators.class);
    private static final SearchIterator EMPTY_ITERATOR = new EmptySearchIterator();

    private SearchIterators() {
    }

    public static void close(SearchIterator<?> iterator) {
        if (null != iterator) {
            try {
                iterator.close();
            }
            catch (Exception e) {
                LOGGER.error("Closing SearchIterator instance failed", (Throwable)e);
            }
        }
    }

    public static <T> List<T> asList(SearchIterator<T> iterator) throws OXException {
        if (null == iterator) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> SearchIterator<T> singletonIterator(T element) {
        if (null == element) {
            return EMPTY_ITERATOR;
        }
        return new SingletonSearchIterator<T>(element);
    }

    public static final <T> SearchIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    private static final class SingletonSearchIterator<T>
    implements SearchIterator<T> {
        private final List<OXException> warnings;
        private T element;

        SingletonSearchIterator(T element) {
            this.element = element;
            this.warnings = new LinkedList<OXException>();
        }

        @Override
        public boolean hasNext() throws OXException {
            return null != this.element;
        }

        @Override
        public T next() throws OXException {
            T retval = this.element;
            if (null == retval) {
                throw new NoSuchElementException();
            }
            this.element = null;
            return retval;
        }

        @Override
        public void close() {
        }

        @Override
        public int size() {
            return null == this.element ? 0 : 1;
        }

        @Override
        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        @Override
        public void addWarning(OXException warning) {
            if (null != warning) {
                this.warnings.add(warning);
            }
        }

        @Override
        public OXException[] getWarnings() {
            int size = this.warnings.size();
            return size == 0 ? null : this.warnings.toArray(new OXException[size]);
        }
    }

    private static final class EmptySearchIterator<T>
    implements SearchIterator<T> {
        EmptySearchIterator() {
        }

        @Override
        public boolean hasNext() throws OXException {
            return false;
        }

        @Override
        public T next() throws OXException {
            throw new NoSuchElementException("Empty iterator has no elements");
        }

        @Override
        public void close() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }

        @Override
        public void addWarning(OXException warning) {
        }

        @Override
        public OXException[] getWarnings() {
            return null;
        }
    }
}

