/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;

public abstract class FilteringSearchIterator<T>
implements SearchIterator<T> {
    private T next = null;
    private final SearchIterator<T> delegate;

    public FilteringSearchIterator(SearchIterator<T> delegate) throws OXException {
        this.delegate = delegate;
        this.initNext();
    }

    public abstract boolean accept(T var1) throws OXException;

    @Override
    public void addWarning(OXException warning) {
        this.delegate.addWarning(warning);
    }

    @Override
    public void close() {
        SearchIterators.close(this.delegate);
    }

    @Override
    public OXException[] getWarnings() {
        return this.delegate.getWarnings();
    }

    @Override
    public boolean hasNext() throws OXException {
        return this.next != null;
    }

    @Override
    public boolean hasWarnings() {
        return this.delegate.hasWarnings();
    }

    @Override
    public T next() throws OXException {
        T current = this.next;
        this.initNext();
        return current;
    }

    @Override
    public int size() {
        return -1;
    }

    protected void initNext() throws OXException {
        while (this.delegate.hasNext()) {
            this.next = this.delegate.next();
            if (!this.accept(this.next)) continue;
            return;
        }
        this.next = null;
    }
}

