/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ServiceExceptionCode implements DisplayableOXExceptionCode
{
    SERVICE_UNAVAILABLE("The required service %1$s is temporary not available. Please try again later.", "A required service is temporarily unavailable. Please try again later.", Category.CATEGORY_TRY_AGAIN, 1),
    IO_ERROR("An I/O error occurred", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 2),
    SERVICE_INITIALIZATION_FAILED("Service initialization failed", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 3);

    private static final String PREFIX = "SRV";
    private final String message;
    private final String displayMessage;
    private final int detailNumber;
    private final Category category;

    public static OXException serviceUnavailable(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        return SERVICE_UNAVAILABLE.create(clazz.getName());
    }

    public static boolean hasPrefix(OXException e) {
        if (null == e) {
            return false;
        }
        return PREFIX.equals(e.getPrefix());
    }

    private ServiceExceptionCode(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage;
        this.detailNumber = detailNumber;
        this.category = category;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public int getNumber() {
        return this.detailNumber;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }

    public static <S> OXException absentService(Class<S> serviceClass) {
        return SERVICE_UNAVAILABLE.create(serviceClass.getName());
    }
}

