/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.marker;

import com.openexchange.marker.OXThreadMarker;
import com.openexchange.startup.impl.ThreadLocalCloseableControl;
import java.io.Closeable;

public class OXThreadMarkers {
    private OXThreadMarkers() {
    }

    public static boolean isHttpRequestProcessing() {
        return OXThreadMarkers.isHttpRequestProcessing(Thread.currentThread());
    }

    public static boolean isHttpRequestProcessing(Thread t) {
        return t instanceof OXThreadMarker && ((OXThreadMarker)((Object)t)).isHttpRequestProcessing();
    }

    public static boolean rememberCloseable(Closeable closeable) {
        if (null == closeable) {
            return false;
        }
        try {
            return ThreadLocalCloseableControl.getInstance().addCloseable(closeable);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean rememberCloseableIfHttpRequestProcessing(Closeable closeable) {
        if (null == closeable) {
            return false;
        }
        Thread t = Thread.currentThread();
        if (t instanceof OXThreadMarker && ((OXThreadMarker)((Object)t)).isHttpRequestProcessing()) {
            try {
                return ThreadLocalCloseableControl.getInstance().addCloseable(closeable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

