/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond;

import com.openexchange.java.util.UUIDs;
import com.openexchange.session.Session;
import com.openexchange.session.SimSession;
import com.openexchange.sessiond.SessionFilter;
import java.util.HashMap;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SessionFilterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testParser1() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new SessionFilter.Parser("").parse();
    }

    @Test
    public void testParser2() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new SessionFilter.Parser("       ").parse();
    }

    @Test
    public void testParser3() throws Exception {
        SessionFilter.Matcher matcher = new SessionFilter.Parser("(a=b)").parse();
        Assert.assertTrue((boolean)matcher.matches(new SessionFilter.Matchee(){

            public boolean matches(String attr, String value, SessionFilter.FilterType type) {
                return "a".equals(attr) && "b".equals(value) && type == SessionFilter.FilterType.EQUAL;
            }
        }));
    }

    @Test
    public void testParser4() throws Exception {
        SessionFilter.Matcher matcher = new SessionFilter.Parser("(|(com.openexchange.attr.A=Ich bin lustiger Text)(com.openexchange.attr.B=Ich auch))").parse();
        Assert.assertTrue((boolean)matcher.matches(new SessionFilter.Matchee(){

            public boolean matches(String attr, String value, SessionFilter.FilterType type) {
                if (attr.equals("com.openexchange.attr.A")) {
                    return type == SessionFilter.FilterType.EQUAL && value.equals("Ich bin lustiger Text");
                }
                if (attr.equals("com.openexchange.attr.B")) {
                    return type == SessionFilter.FilterType.EQUAL && value.equals("Ich auch");
                }
                return false;
            }
        }));
    }

    @Test
    public void testParser5() throws Exception {
        final HashMap<String, String> values = new HashMap<String, String>();
        SessionFilter.Matchee mapMatchee = new SessionFilter.Matchee(){

            public boolean matches(String attr, String value, SessionFilter.FilterType type) {
                if (type != SessionFilter.FilterType.EQUAL) {
                    return false;
                }
                String string = (String)values.get(attr);
                if (string == null) {
                    return false;
                }
                return string.equals(value);
            }
        };
        values.put("com.openexchange.attr.A", "valueForA");
        Assert.assertTrue((boolean)SessionFilterTest.matches("(|(com.openexchange.attr.C=asdasfasdf)(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.A=valueForA))", mapMatchee));
        Assert.assertFalse((boolean)SessionFilterTest.matches("(|(com.openexchange.attr.C=asdasfasdf)(com.openexchange.attr.B=sdfsdfsdfsdfd))", mapMatchee));
        Assert.assertFalse((boolean)SessionFilterTest.matches("(&(com.openexchange.attr.C=asdasfasdf)(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.A=valueForA))", mapMatchee));
        values.put("com.openexchange.attr.B", "sdfsdfsdfsdfd");
        values.put("com.openexchange.attr.C", "asdasfasdf");
        Assert.assertTrue((boolean)SessionFilterTest.matches("(&(com.openexchange.attr.C=asdasfasdf)(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.A=valueForA))", mapMatchee));
        Assert.assertFalse((boolean)SessionFilterTest.matches("(!(&(com.openexchange.attr.C=asdasfasdf)(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.A=valueForA)))", mapMatchee));
        values.clear();
        Assert.assertTrue((boolean)SessionFilterTest.matches("(!(&(com.openexchange.attr.C=asdasfasdf)(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.A=valueForA)))", mapMatchee));
        values.put("com.openexchange.attr.A", "valueForA");
        values.put("com.openexchange.attr.B", "sdfsdfsdfsdfd");
        values.put("com.openexchange.attr.C", "asdasfasdf");
        Assert.assertTrue((boolean)SessionFilterTest.matches("(&(!(com.openexchange.attr.A=mumpitz))(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.C=asdasfasdf))", mapMatchee));
        Assert.assertFalse((boolean)SessionFilterTest.matches("(!(&(!(com.openexchange.attr.A=mumpitz))(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.C=asdasfasdf)))", mapMatchee));
    }

    @Test
    public void testParser6() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new SessionFilter.Parser("(!(&(!(com.openexchange.attr.A=mumpitz))(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.C=asdasfasdf))))").parse();
    }

    @Test
    public void testParser7() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new SessionFilter.Parser("(!(&(!(com.openexchange.attr.A=mumpitz))(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.C=asdasfasdf))").parse();
    }

    @Test
    public void testParser8() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new SessionFilter.Parser("(!(&(!(com.openexchange.attr.A=mumpitz))(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.C=asdasfasdf)))  )").parse();
    }

    @Test
    public void testParser9() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new SessionFilter.Parser("(!(&(!(com.openexchange.attr.A=mumpitz))(com.openexchange.attr.B=sdfsdfsdfsdfd)(com.openexchange.attr.C=asdasfasdf)))asd").parse();
    }

    @Test
    public void testParser10() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        new SessionFilter.Parser("(!(&(!(com.openexchange.attr.A=mumpitz))(com.openexchange.attr.B=sdfsdfsdfsdfd))(com.openexchange.attr.C=asdasfasdf)))asd").parse();
    }

    @Test
    public void testFilter1() throws Exception {
        String sessionId = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        String secret = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        String hash = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        String auth = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        String client = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        SimSession simSession = new SimSession(24, 48);
        simSession.setSessionID(sessionId);
        simSession.setHash(hash);
        simSession.setSecret(secret);
        simSession.setAuthId(auth);
        simSession.setClient(client);
        simSession.setParameter("com.openexchange.attr.A", "mumpitz");
        SessionFilter filter = SessionFilter.create((String)("(&(contextId=48)(userId=24)(sessionId=" + sessionId + ")" + "(" + "secret" + "=" + secret + ")" + "(" + "hash" + "=" + hash + ")" + "(" + "authId" + "=" + auth + ")" + "(" + "client" + "=" + client + ")" + "(com.openexchange.attr.A=mumpitz)" + ")"));
        Assert.assertTrue((boolean)filter.apply((Session)simSession));
    }

    private static boolean matches(String filter, SessionFilter.Matchee matchee) {
        return new SessionFilter.Parser(filter).parse().matches(matchee);
    }
}

