/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Actions;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Actions(value={@Action(method=RequestMethod.PUT, name="update", description="Update an infoitem via PUT", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="timestamp", description="Timestamp of the updated infoitem. If the infoitem was modified after the specified timestamp, then the update must fail.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present."), @Action(method=RequestMethod.POST, name="update", description="Update an infoitem via POST", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="offset", optional=true, description="Optionally sets the start offset in bytes where to append the data to the document, must be equal to the actual document's length."), @Parameter(name="timestamp", description="Timestamp of the updated infoitem. If the infoitem was modified after the specified timestamp, then the update must fail."), @Parameter(name="json", description="Infoitem object as described in Common object data and Detailed infoitem data. The field id is not included."), @Parameter(name="file", description="File metadata as per <input type=\"file\" />")}, requestBody="Body of content-type \"multipart/form-data\" or \"multipart/mixed\" containing the above mentioned fields and file-data.", responseDescription="The response is sent as a HTML document (see introduction).")})
public class UpdateAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        String newId;
        request.requireFileMetadata().require(AbstractFileAction.Param.TIMESTAMP);
        File file = request.getFile();
        if (file.getId() == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"id"});
        }
        FileID id = new FileID(file.getId());
        IDBasedFileAccess fileAccess = request.getFileAccess();
        boolean ignoreWarnings = AJAXRequestDataTools.parseBoolParameter((String)"ignoreWarnings", (AJAXRequestData)request.getRequestData(), (boolean)false);
        List<File.Field> columns = request.getSentColumns();
        boolean notify = request.notifyPermissionEntities() && columns.contains(File.Field.OBJECT_PERMISSIONS) && file.getObjectPermissions() != null && file.getObjectPermissions().size() > 0;
        File original = null;
        if (notify) {
            original = fileAccess.getFileMetadata(file.getId(), FileStorageFileAccess.CURRENT_VERSION);
        }
        if (request.hasUploads()) {
            int offset = AJAXRequestDataTools.parseIntParameter((String)request.getParameter("offset"), (int)0);
            if (0 < offset) {
                newId = fileAccess.saveDocument(file, request.getUploadedFileData(), request.getTimestamp(), columns, (long)offset);
            } else {
                boolean ignoreVersion = request.getBoolParameter("ignoreVersion") && fileAccess.supports(id.getService(), id.getAccountId(), new FileStorageCapability[]{FileStorageCapability.IGNORABLE_VERSION});
                newId = fileAccess.saveDocument(file, request.getUploadedFileData(), request.getTimestamp(), columns, ignoreVersion, ignoreWarnings, false);
            }
        } else {
            newId = fileAccess.saveFileMetadata(file, request.getTimestamp(), columns, ignoreWarnings, false);
        }
        ArrayList<OXException> warnings = new ArrayList<OXException>(fileAccess.getAndFlushWarnings());
        if (notify && null != newId) {
            File modified = fileAccess.getFileMetadata(newId, FileStorageFileAccess.CURRENT_VERSION);
            warnings.addAll(this.sendNotifications(request.getNotificationTransport(), request.getNotifiactionMessage(), original, modified, (Session)request.getSession(), request.getRequestData().getHostData()));
        }
        AJAXRequestResult result = null != newId && request.extendedResponse() ? this.result(fileAccess.getFileMetadata(newId, FileStorageFileAccess.CURRENT_VERSION), request) : new AJAXRequestResult((Object)newId, new Date(file.getSequenceNumber()));
        result.addWarnings(warnings);
        if (null == newId && null != warnings && !warnings.isEmpty() && !ignoreWarnings) {
            result.setException(FileStorageExceptionCodes.FILE_UPDATE_ABORTED.create(new Object[]{UpdateAction.getFilenameSave(file, id, fileAccess), id.toUniqueID()}));
        }
        return result;
    }
}

