/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AbstractFileFieldHandler;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.meta.FileFieldGet;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.ShareRecipient;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldHandler
extends AbstractFileFieldHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFieldHandler.class);
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final FileFieldGet get = new FileFieldGet();
    private final AJAXInfostoreRequest request;

    public JsonFieldHandler(AJAXInfostoreRequest request) {
        this.request = request;
    }

    public Object handle(File.Field field, Object ... args) {
        Object value = field.doSwitch((FileFieldSwitcher)get, args);
        if (File.Field.FILE_MIMETYPE == field) {
            if (null == value) {
                return value;
            }
            String ct = value.toString();
            if (ct.indexOf(59) <= 0) {
                return value;
            }
            try {
                return ContentType.getBaseType((String)ct);
            }
            catch (OXException e) {
                return value;
            }
        }
        if (value == null && field == File.Field.LOCKED_UNTIL) {
            return 0;
        }
        if (Date.class.isInstance(value)) {
            Date d = (Date)value;
            if (field == File.Field.LOCKED_UNTIL && (d == null || d.getTime() <= System.currentTimeMillis())) {
                return 0;
            }
            TimeZone tz = File.Field.LAST_MODIFIED_UTC == field ? UTC : this.request.getTimezone();
            return this.writeDate((Date)value, tz);
        }
        switch (field) {
            case CATEGORIES: {
                return this.handleCategories((String)value);
            }
            case META: {
                try {
                    if (value == null) {
                        return null;
                    }
                    return JSONCoercion.coerceToJSON((Object)value);
                }
                catch (JSONException e) {
                    LOG.error("", (Throwable)e);
                    return null;
                }
            }
            case OBJECT_PERMISSIONS: {
                if (value != null && value instanceof List) {
                    List list = (List)value;
                    JSONArray jPermissions = new JSONArray(list.size());
                    for (Object obj : list) {
                        FileStorageGuestObjectPermission permission;
                        if (obj instanceof FileStorageGuestObjectPermission) {
                            permission = (FileStorageGuestObjectPermission)obj;
                            ShareRecipient recipient = permission.getRecipient();
                            JSONObject json = new JSONObject();
                            try {
                                json.put("type", (Object)recipient.getType().toString().toLowerCase());
                                json.put("bits", permission.getPermissions());
                                switch (recipient.getType()) {
                                    case ANONYMOUS: {
                                        json.putOpt("password", (Object)((AnonymousRecipient)recipient).getPassword());
                                        break;
                                    }
                                    case GUEST: {
                                        GuestRecipient guestRecipient = (GuestRecipient)recipient;
                                        json.putOpt("password", (Object)guestRecipient.getPassword());
                                        json.putOpt("email_address", (Object)guestRecipient.getEmailAddress());
                                        json.putOpt("display_name", (Object)guestRecipient.getDisplayName());
                                        json.putOpt("contact_id", (Object)guestRecipient.getContactID());
                                        json.putOpt("contact_folder", (Object)guestRecipient.getContactFolder());
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException("Unable to write recipients of type " + recipient.getType());
                                    }
                                }
                                jPermissions.put((Object)json);
                                continue;
                            }
                            catch (JSONException e) {
                                LOG.error("", (Throwable)e);
                                return null;
                            }
                        }
                        if (!(obj instanceof FileStorageObjectPermission)) continue;
                        permission = (FileStorageObjectPermission)obj;
                        JSONObject json = new JSONObject(3);
                        try {
                            json.put("entity", permission.getEntity());
                            json.put("group", permission.isGroup());
                            json.put("bits", permission.getPermissions());
                            jPermissions.put((Object)json);
                        }
                        catch (JSONException e) {
                            LOG.error("", (Throwable)e);
                            return null;
                        }
                    }
                    return jPermissions;
                }
                return new JSONArray(0);
            }
        }
        return value;
    }

    private Object writeDate(Date date, TimeZone tz) {
        int offset = tz == null ? 0 : tz.getOffset(date.getTime());
        long time = date.getTime() + (long)offset;
        if (time < 0L) {
            time = Long.MAX_VALUE;
        }
        return time;
    }

    private JSONArray handleCategories(String value) {
        if (value == null) {
            return null;
        }
        String[] strings = Strings.splitByComma((String)value);
        JSONArray array = new JSONArray();
        for (String string : strings) {
            array.put((Object)string);
        }
        return array;
    }
}

