/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.json.FileMetadataWriter;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.osgi.FileFieldCollector;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import org.json.JSONArray;

public class FileConverter
implements ResultConverter {
    private final FileMetadataWriter writer;

    public FileConverter(FileFieldCollector fieldCollector) {
        this.writer = new FileMetadataWriter(fieldCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        Object resultObject;
        block10: {
            block12: {
                AJAXInfostoreRequest infostoreRequest;
                block11: {
                    block9: {
                        infostoreRequest = new AJAXInfostoreRequest(requestData, session);
                        resultObject = result.getResultObject();
                        if (!File.class.isInstance(resultObject)) break block9;
                        resultObject = this.writer.write(infostoreRequest, (File)resultObject);
                        break block10;
                    }
                    if (!TimedResult.class.isInstance(resultObject)) break block11;
                    SearchIterator searchIterator = null;
                    try {
                        TimedResult timedResult = (TimedResult)resultObject;
                        result.setTimestamp(new Date(timedResult.sequenceNumber()));
                        searchIterator = timedResult.results();
                        resultObject = this.writer.write(infostoreRequest, (SearchIterator<File>)searchIterator);
                    }
                    catch (Throwable throwable) {
                        SearchIterators.close(searchIterator);
                        throw throwable;
                    }
                    SearchIterators.close((SearchIterator)searchIterator);
                    break block10;
                }
                if (SearchIterator.class.isInstance(resultObject)) {
                    SearchIterator searchIterator = null;
                    try {
                        searchIterator = (SearchIterator)resultObject;
                        resultObject = this.writer.write(infostoreRequest, (SearchIterator<File>)searchIterator);
                    }
                    finally {
                        SearchIterators.close((SearchIterator)searchIterator);
                    }
                }
                if (!Delta.class.isInstance(resultObject)) break block12;
                SearchIterator newAndModifiedIterator = null;
                SearchIterator deletedIterator = null;
                try {
                    Delta deltaResult = (Delta)resultObject;
                    newAndModifiedIterator = deltaResult.results();
                    JSONArray jsonArray = this.writer.write(infostoreRequest, (SearchIterator<File>)newAndModifiedIterator);
                    deletedIterator = deltaResult.getDeleted();
                    while (deletedIterator.hasNext()) {
                        jsonArray.put((Object)((File)deletedIterator.next()).getId());
                    }
                    resultObject = jsonArray;
                }
                catch (Throwable throwable) {
                    SearchIterators.close(newAndModifiedIterator);
                    SearchIterators.close(deletedIterator);
                    throw throwable;
                }
                SearchIterators.close((SearchIterator)newAndModifiedIterator);
                SearchIterators.close((SearchIterator)deletedIterator);
                break block10;
            }
            throw new UnsupportedOperationException("unknown result object");
        }
        result.setResultObject(resultObject);
    }

    public String getInputFormat() {
        return "infostore";
    }

    public String getOutputFormat() {
        return "json";
    }

    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }
}

