/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.search;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.search.ComparablePattern;
import com.openexchange.file.storage.search.SearchTerm;

public abstract class AbstractNumberSearchTerm
implements SearchTerm<ComparablePattern<Number>> {
    protected final ComparablePattern<Number> pattern;

    protected AbstractNumberSearchTerm(ComparablePattern<Number> pattern) {
        this.pattern = pattern;
    }

    @Override
    public ComparablePattern<Number> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean matches(File file) throws OXException {
        Number number = this.getNumber(file);
        if (null == number) {
            return false;
        }
        if (this.compareLongValues()) {
            switch (this.pattern.getComparisonType()) {
                case EQUALS: {
                    return number.longValue() == this.pattern.getPattern().longValue();
                }
                case LESS_THAN: {
                    return number.longValue() < this.pattern.getPattern().longValue();
                }
                case GREATER_THAN: {
                    return number.longValue() > this.pattern.getPattern().longValue();
                }
            }
            return false;
        }
        switch (this.pattern.getComparisonType()) {
            case EQUALS: {
                return number.intValue() == this.pattern.getPattern().intValue();
            }
            case LESS_THAN: {
                return number.intValue() < this.pattern.getPattern().intValue();
            }
            case GREATER_THAN: {
                return number.intValue() > this.pattern.getPattern().intValue();
            }
        }
        return false;
    }

    protected abstract Number getNumber(File var1);

    protected abstract boolean compareLongValues();
}

