/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class FileStorageConfigReloadable
implements Reloadable {
    private static final String CONFIGFILE = "filestorage.properties";
    private static final String[] PROPERTIES = new String[]{"com.openexchange.file.storage.numberOfPregeneratedPreviews"};
    private static final FileStorageConfigReloadable INSTANCE = new FileStorageConfigReloadable();
    private final List<Reloadable> reloadables = new CopyOnWriteArrayList<Reloadable>();

    public static FileStorageConfigReloadable getInstance() {
        return INSTANCE;
    }

    private FileStorageConfigReloadable() {
    }

    public void addReloadable(Reloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    public void reloadConfiguration(ConfigurationService configService) {
        for (Reloadable reloadable : this.reloadables) {
            reloadable.reloadConfiguration(configService);
        }
    }

    public Map<String, String[]> getConfigFileNames() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put(CONFIGFILE, PROPERTIES);
        return map;
    }
}

