/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.file.storage.FileFieldHandler;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.FileStorageObjectPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface File {
    public static final Set<Field> DEFAULT_SEARCH_FIELDS = Collections.unmodifiableSet(EnumSet.of(Field.TITLE, new Field[]{Field.FILENAME, Field.DESCRIPTION, Field.URL, Field.CATEGORIES, Field.VERSION_COMMENT}));

    public String getProperty(String var1);

    public Set<String> getPropertyNames();

    public Date getLastModified();

    public void setLastModified(Date var1);

    public Date getCreated();

    public void setCreated(Date var1);

    public int getModifiedBy();

    public void setModifiedBy(int var1);

    public String getFolderId();

    public void setFolderId(String var1);

    public String getTitle();

    public void setTitle(String var1);

    public String getVersion();

    public void setVersion(String var1);

    public String getContent();

    public long getFileSize();

    public void setFileSize(long var1);

    public String getFileMIMEType();

    public void setFileMIMEType(String var1);

    public String getFileName();

    public void setFileName(String var1);

    public String getId();

    public void setId(String var1);

    public int getCreatedBy();

    public void setCreatedBy(int var1);

    public String getDescription();

    public void setDescription(String var1);

    public String getURL();

    public void setURL(String var1);

    public long getSequenceNumber();

    public String getCategories();

    public void setCategories(String var1);

    public Date getLockedUntil();

    public void setLockedUntil(Date var1);

    public String getFileMD5Sum();

    public void setFileMD5Sum(String var1);

    public int getColorLabel();

    public void setColorLabel(int var1);

    public boolean isCurrentVersion();

    public void setIsCurrentVersion(boolean var1);

    public String getVersionComment();

    public void setVersionComment(String var1);

    public void setNumberOfVersions(int var1);

    public int getNumberOfVersions();

    public Map<String, Object> getMeta();

    public void setMeta(Map<String, Object> var1);

    public boolean isAccurateSize();

    public void setAccurateSize(boolean var1);

    public List<FileStorageObjectPermission> getObjectPermissions();

    public void setObjectPermissions(List<FileStorageObjectPermission> var1);

    public boolean isShareable();

    public void setShareable(boolean var1);

    public File dup();

    public void copyInto(File var1);

    public void copyFrom(File var1);

    public void copyInto(File var1, Field ... var2);

    public void copyFrom(File var1, Field ... var2);

    public Set<Field> differences(File var1);

    public boolean equals(File var1, Field var2, Field ... var3);

    public boolean matches(String var1, Field ... var2);

    public static enum Field {
        LAST_MODIFIED("last_modified", 5),
        CREATED("creation_date", 4),
        MODIFIED_BY("modified_by", 3),
        FOLDER_ID("folder_id", 20),
        TITLE("title", 700),
        VERSION("version", 705),
        CONTENT("content", 750),
        ID("id", 1),
        FILE_SIZE("file_size", 704),
        DESCRIPTION("description", 706),
        URL("url", 701),
        CREATED_BY("created_by", 2),
        FILENAME("filename", 702),
        FILE_MIMETYPE("file_mimetype", 703),
        SEQUENCE_NUMBER("sequence_number", 751),
        CATEGORIES("categories", 100),
        LOCKED_UNTIL("locked_until", 707),
        FILE_MD5SUM("file_md5sum", 708),
        VERSION_COMMENT("version_comment", 709),
        CURRENT_VERSION("current_version", 710),
        COLOR_LABEL("color_label", 102),
        LAST_MODIFIED_UTC("last_modified_utc", 6),
        NUMBER_OF_VERSIONS("number_of_versions", 711),
        META("meta", 23),
        OBJECT_PERMISSIONS("object_permissions", 108),
        SHAREABLE("shareable", 109);

        private final int number;
        private final String name;
        private static final Map<String, Field> byName;
        private static final Map<Integer, Field> byNumber;

        private Field(String name, int number) {
            this.number = number;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public Object doSwitch(FileFieldSwitcher switcher, Object ... args) {
            switch (this) {
                case LAST_MODIFIED: {
                    return switcher.lastModified(args);
                }
                case CREATED: {
                    return switcher.created(args);
                }
                case MODIFIED_BY: {
                    return switcher.modifiedBy(args);
                }
                case FOLDER_ID: {
                    return switcher.folderId(args);
                }
                case TITLE: {
                    return switcher.title(args);
                }
                case VERSION: {
                    return switcher.version(args);
                }
                case CONTENT: {
                    return switcher.content(args);
                }
                case ID: {
                    return switcher.id(args);
                }
                case FILE_SIZE: {
                    return switcher.fileSize(args);
                }
                case DESCRIPTION: {
                    return switcher.description(args);
                }
                case URL: {
                    return switcher.url(args);
                }
                case CREATED_BY: {
                    return switcher.createdBy(args);
                }
                case FILENAME: {
                    return switcher.filename(args);
                }
                case FILE_MIMETYPE: {
                    return switcher.fileMimetype(args);
                }
                case SEQUENCE_NUMBER: {
                    return switcher.sequenceNumber(args);
                }
                case CATEGORIES: {
                    return switcher.categories(args);
                }
                case LOCKED_UNTIL: {
                    return switcher.lockedUntil(args);
                }
                case FILE_MD5SUM: {
                    return switcher.fileMd5sum(args);
                }
                case VERSION_COMMENT: {
                    return switcher.versionComment(args);
                }
                case CURRENT_VERSION: {
                    return switcher.currentVersion(args);
                }
                case COLOR_LABEL: {
                    return switcher.colorLabel(args);
                }
                case LAST_MODIFIED_UTC: {
                    return switcher.lastModifiedUtc(args);
                }
                case NUMBER_OF_VERSIONS: {
                    return switcher.numberOfVersions(args);
                }
                case META: {
                    return switcher.meta(args);
                }
                case OBJECT_PERMISSIONS: {
                    return switcher.objectPermissions(args);
                }
                case SHAREABLE: {
                    return switcher.shareable(args);
                }
            }
            throw new IllegalArgumentException("Don't know field: " + this.getName());
        }

        public static List<Object> forAllFields(FileFieldSwitcher switcher, Object ... args) {
            ArrayList<Object> retval = new ArrayList<Object>(Field.values().length);
            for (Field field : Field.values()) {
                retval.add(field.doSwitch(switcher, args));
            }
            return retval;
        }

        public static <T> T inject(FileFieldSwitcher switcher, T arg, Object ... args) {
            Object[] newArgs = new Object[args.length + 1];
            newArgs[0] = arg;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            for (Field field : Field.values()) {
                arg = field.doSwitch(switcher, args);
            }
            return arg;
        }

        public Object handle(FileFieldHandler handler, Object ... args) {
            return handler.handle(this, args);
        }

        public static List<Object> forAllFields(FileFieldHandler handler, Object ... args) {
            ArrayList<Object> retval = new ArrayList<Object>(Field.values().length);
            for (Field field : Field.values()) {
                retval.add(field.handle(handler, args));
            }
            return retval;
        }

        public static <T> T inject(FileFieldHandler handler, T arg, Object ... args) {
            Object[] newArgs = new Object[args.length + 1];
            newArgs[0] = arg;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            for (Field field : Field.values()) {
                arg = field.handle(handler, newArgs);
            }
            return arg;
        }

        public static Field get(String key) {
            if (key == null) {
                return null;
            }
            Field field = byName.get(key);
            if (field != null) {
                return field;
            }
            try {
                int number = Integer.parseInt(key);
                return byNumber.get(number);
            }
            catch (NumberFormatException x) {
                return null;
            }
        }

        public static List<Field> get(Collection<String> keys) {
            if (keys == null) {
                return Collections.emptyList();
            }
            ArrayList<Field> retval = new ArrayList<Field>(keys.size());
            for (String key : keys) {
                retval.add(Field.get(key));
            }
            return retval;
        }

        public static Field get(int number) {
            return byNumber.get(number);
        }

        public static List<Field> get(int[] numbers) {
            ArrayList<Field> fields = new ArrayList<Field>(numbers.length);
            for (int number : numbers) {
                Field field = byNumber.get(number);
                if (field == null) continue;
                fields.add(field);
            }
            return fields;
        }

        static {
            byName = new HashMap<String, Field>();
            for (Field field : Field.values()) {
                byName.put(field.getName(), field);
            }
            byNumber = new HashMap<Integer, Field>();
            for (Field field : Field.values()) {
                byNumber.put(field.getNumber(), field);
            }
        }
    }
}

