/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class FieldMapping {
    private static final Map<File.Field, Metadata> field2metadata = new EnumMap<File.Field, Metadata>(File.Field.class);

    public static Metadata getMatching(File.Field field) {
        return field2metadata.get(field);
    }

    public static Metadata[] getMatching(List<File.Field> fields) {
        Metadata[] retval = new Metadata[fields.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = FieldMapping.getMatching(fields.get(i));
        }
        return retval;
    }

    public static int getSortDirection(FileStorageFileAccess.SortDirection order) {
        return FileStorageFileAccess.SortDirection.DESC.equals((Object)order) ? -1 : 1;
    }

    static {
        field2metadata.put(File.Field.LAST_MODIFIED, Metadata.LAST_MODIFIED_LITERAL);
        field2metadata.put(File.Field.CREATED, Metadata.CREATION_DATE_LITERAL);
        field2metadata.put(File.Field.MODIFIED_BY, Metadata.MODIFIED_BY_LITERAL);
        field2metadata.put(File.Field.FOLDER_ID, Metadata.FOLDER_ID_LITERAL);
        field2metadata.put(File.Field.TITLE, Metadata.TITLE_LITERAL);
        field2metadata.put(File.Field.VERSION, Metadata.VERSION_LITERAL);
        field2metadata.put(File.Field.CONTENT, Metadata.CONTENT_LITERAL);
        field2metadata.put(File.Field.ID, Metadata.ID_LITERAL);
        field2metadata.put(File.Field.FILE_SIZE, Metadata.FILE_SIZE_LITERAL);
        field2metadata.put(File.Field.DESCRIPTION, Metadata.DESCRIPTION_LITERAL);
        field2metadata.put(File.Field.URL, Metadata.URL_LITERAL);
        field2metadata.put(File.Field.CREATED_BY, Metadata.CREATED_BY_LITERAL);
        field2metadata.put(File.Field.FILENAME, Metadata.FILENAME_LITERAL);
        field2metadata.put(File.Field.FILE_MIMETYPE, Metadata.FILE_MIMETYPE_LITERAL);
        field2metadata.put(File.Field.SEQUENCE_NUMBER, Metadata.SEQUENCE_NUMBER_LITERAL);
        field2metadata.put(File.Field.CATEGORIES, Metadata.CATEGORIES_LITERAL);
        field2metadata.put(File.Field.LOCKED_UNTIL, Metadata.LOCKED_UNTIL_LITERAL);
        field2metadata.put(File.Field.FILE_MD5SUM, Metadata.FILE_MD5SUM_LITERAL);
        field2metadata.put(File.Field.VERSION_COMMENT, Metadata.VERSION_COMMENT_LITERAL);
        field2metadata.put(File.Field.CURRENT_VERSION, Metadata.CURRENT_VERSION_LITERAL);
        field2metadata.put(File.Field.COLOR_LABEL, Metadata.COLOR_LABEL_LITERAL);
        field2metadata.put(File.Field.LAST_MODIFIED_UTC, Metadata.LAST_MODIFIED_UTC_LITERAL);
        field2metadata.put(File.Field.NUMBER_OF_VERSIONS, Metadata.NUMBER_OF_VERSIONS_LITERAL);
        field2metadata.put(File.Field.META, Metadata.META_LITERAL);
        field2metadata.put(File.Field.OBJECT_PERMISSIONS, Metadata.OBJECT_PERMISSIONS_LITERAL);
        field2metadata.put(File.Field.SHAREABLE, Metadata.SHAREABLE_LITERAL);
    }
}

