/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.UserizedFile;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.infostore.PermissionHelper;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.java.Strings;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileMetadata
implements DocumentMetadata {
    private static final long serialVersionUID = 2097235173990058583L;
    private final File file;
    private String fileSpool;

    public FileMetadata(File document) throws OXException {
        FileMetadata.validate(document);
        this.file = document;
    }

    public String getCategories() {
        return this.file.getCategories();
    }

    public int getColorLabel() {
        return this.file.getColorLabel();
    }

    public String getContent() {
        return this.file.getContent();
    }

    public Date getCreationDate() {
        return this.file.getCreated();
    }

    public int getCreatedBy() {
        return this.file.getCreatedBy();
    }

    public String getDescription() {
        return this.file.getDescription();
    }

    public String getFileMD5Sum() {
        return this.file.getFileMD5Sum();
    }

    public String getFileMIMEType() {
        return this.file.getFileMIMEType();
    }

    public String getFileName() {
        return this.file.getFileName();
    }

    public long getFileSize() {
        return this.file.getFileSize();
    }

    public long getFolderId() {
        if (this.file.getFolderId() == null) {
            return -1L;
        }
        return Long.valueOf(this.file.getFolderId());
    }

    public int getId() {
        if (this.file.getId() == FileStorageFileAccess.NEW) {
            return -1;
        }
        return Integer.valueOf(this.file.getId());
    }

    public Date getLastModified() {
        return this.file.getLastModified();
    }

    public Date getLockedUntil() {
        return this.file.getLockedUntil();
    }

    public int getModifiedBy() {
        return this.file.getModifiedBy();
    }

    public int getNumberOfVersions() {
        return this.file.getNumberOfVersions();
    }

    public String getProperty(String key) {
        return this.file.getProperty(key);
    }

    public Set<String> getPropertyNames() {
        return this.file.getPropertyNames();
    }

    public long getSequenceNumber() {
        return this.file.getSequenceNumber();
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public String getURL() {
        return this.file.getURL();
    }

    public int getVersion() {
        String version = this.file.getVersion();
        return Strings.isEmpty((String)version) ? -1 : Integer.parseInt(version);
    }

    public String getVersionComment() {
        return this.file.getVersionComment();
    }

    public boolean isCurrentVersion() {
        return this.file.isCurrentVersion();
    }

    public void setCategories(String categories) {
        this.file.setCategories(categories);
    }

    public void setColorLabel(int color) {
        this.file.setColorLabel(color);
    }

    public void setCreationDate(Date creationDate) {
        this.file.setCreated(creationDate);
    }

    public void setCreatedBy(int cretor) {
        this.file.setCreatedBy(cretor);
    }

    public void setDescription(String description) {
        this.file.setDescription(description);
    }

    public void setFileMD5Sum(String sum) {
        this.file.setFileMD5Sum(sum);
    }

    public void setFileMIMEType(String type) {
        this.file.setFileMIMEType(type);
    }

    public void setFileName(String fileName) {
        this.file.setFileName(fileName);
    }

    public void setFileSize(long length) {
        this.file.setFileSize(length);
    }

    public void setFolderId(long folderId) {
        this.file.setFolderId(Long.toString(folderId));
    }

    public void setId(int id) {
        this.file.setId(String.valueOf(id));
    }

    public void setIsCurrentVersion(boolean bool) {
        this.file.setIsCurrentVersion(bool);
    }

    public void setLastModified(Date now) {
        this.file.setLastModified(now);
    }

    public void setLockedUntil(Date lockedUntil) {
        this.file.setLockedUntil(lockedUntil);
    }

    public void setModifiedBy(int lastEditor) {
        this.file.setModifiedBy(lastEditor);
    }

    public void setNumberOfVersions(int numberOfVersions) {
        this.file.setNumberOfVersions(numberOfVersions);
    }

    public void setTitle(String title) {
        this.file.setTitle(title);
    }

    public void setURL(String url) {
        this.file.setURL(url);
    }

    public void setVersion(int version) {
        this.file.setVersion(version < 0 ? FileStorageFileAccess.CURRENT_VERSION : Integer.toString(version));
    }

    public void setVersionComment(String string) {
        this.file.setVersionComment(string);
    }

    public String getFilestoreLocation() {
        return this.fileSpool;
    }

    public void setFilestoreLocation(String string) {
        this.fileSpool = string;
    }

    public Map<String, Object> getMeta() {
        return this.file.getMeta();
    }

    public void setMeta(Map<String, Object> properties) {
        this.file.setMeta(properties);
    }

    public List<ObjectPermission> getObjectPermissions() {
        return PermissionHelper.getObjectPermissions(this.file.getObjectPermissions());
    }

    public void setObjectPermissions(List<ObjectPermission> objectPermissions) {
        this.file.setObjectPermissions(PermissionHelper.getFileStorageObjectPermissions(objectPermissions));
    }

    public boolean isShareable() {
        return this.file.isShareable();
    }

    public void setShareable(boolean shareable) {
        this.file.setShareable(shareable);
    }

    private static void validate(File file) throws OXException {
        if (null != file) {
            String folderID;
            String id = file.getId();
            if (FileStorageFileAccess.NEW != id) {
                try {
                    Integer.valueOf(id);
                }
                catch (NumberFormatException e) {
                    throw FileStorageExceptionCodes.INVALID_FILE_IDENTIFIER.create((Throwable)e, new Object[]{id});
                }
            }
            if (null != (folderID = file.getFolderId())) {
                try {
                    Integer.valueOf(folderID);
                }
                catch (NumberFormatException e) {
                    throw FileStorageExceptionCodes.INVALID_FOLDER_IDENTIFIER.create((Throwable)e, new Object[]{folderID});
                }
            }
        }
    }

    public static DocumentMetadata getMetadata(final File file) {
        DocumentMetadata metaData = new DocumentMetadata(){
            private static final long serialVersionUID = -1476628439761201503L;

            public void setVersionComment(String string) {
            }

            public void setVersion(int version) {
            }

            public void setURL(String url) {
            }

            public void setTitle(String title) {
            }

            public void setNumberOfVersions(int numberOfVersions) {
            }

            public void setModifiedBy(int lastEditor) {
            }

            public void setLockedUntil(Date lockedUntil) {
            }

            public void setLastModified(Date now) {
            }

            public void setIsCurrentVersion(boolean bool) {
            }

            public void setId(int id) {
            }

            public void setFolderId(long folderId) {
            }

            public void setFilestoreLocation(String string) {
            }

            public void setFileSize(long length) {
            }

            public void setFileName(String fileName) {
            }

            public void setFileMIMEType(String type) {
            }

            public void setFileMD5Sum(String sum) {
            }

            public void setDescription(String description) {
            }

            public void setCreationDate(Date creationDate) {
            }

            public void setCreatedBy(int cretor) {
            }

            public void setColorLabel(int color) {
            }

            public void setCategories(String categories) {
            }

            public void setOriginalId(int id) {
            }

            public void setOriginalFolderId(long id) {
            }

            public boolean isCurrentVersion() {
                return file.isCurrentVersion();
            }

            public String getVersionComment() {
                return file.getVersionComment();
            }

            public int getVersion() {
                return Integer.parseInt(file.getVersion());
            }

            public String getURL() {
                return file.getURL();
            }

            public String getTitle() {
                return file.getTitle();
            }

            public long getSequenceNumber() {
                return file.getSequenceNumber();
            }

            public Set<String> getPropertyNames() {
                return file.getPropertyNames();
            }

            public String getProperty(String key) {
                return file.getProperty(key);
            }

            public int getNumberOfVersions() {
                return file.getNumberOfVersions();
            }

            public int getModifiedBy() {
                return file.getModifiedBy();
            }

            public Date getLockedUntil() {
                return file.getLockedUntil();
            }

            public Date getLastModified() {
                return file.getLastModified();
            }

            public int getId() {
                String id = file.getId();
                if (FileStorageFileAccess.NEW == id) {
                    return -1;
                }
                return Integer.parseInt(new FileID(id).getFileId());
            }

            public long getFolderId() {
                String id = file.getFolderId();
                if (FileStorageFileAccess.NEW == id) {
                    return -1L;
                }
                return Long.parseLong(new FolderID(id).getFolderId());
            }

            public String getFilestoreLocation() {
                return null;
            }

            public long getFileSize() {
                return file.getFileSize();
            }

            public String getFileName() {
                return file.getFileName();
            }

            public String getFileMIMEType() {
                return file.getFileMIMEType();
            }

            public String getFileMD5Sum() {
                return file.getFileMD5Sum();
            }

            public String getDescription() {
                return file.getDescription();
            }

            public Date getCreationDate() {
                return file.getCreated();
            }

            public int getCreatedBy() {
                return file.getCreatedBy();
            }

            public String getContent() {
                return file.getContent();
            }

            public int getColorLabel() {
                return file.getColorLabel();
            }

            public String getCategories() {
                return file.getCategories();
            }

            public Map<String, Object> getMeta() {
                return file.getMeta();
            }

            public void setMeta(Map<String, Object> properties) {
            }

            public List<ObjectPermission> getObjectPermissions() {
                return PermissionHelper.getObjectPermissions(file.getObjectPermissions());
            }

            public void setObjectPermissions(List<ObjectPermission> objectPermissions) {
            }

            public boolean isShareable() {
                return file.isShareable();
            }

            public void setShareable(boolean shareable) {
                file.setShareable(shareable);
            }

            public int getOriginalId() {
                if (file instanceof UserizedFile) {
                    return Integer.parseInt(((UserizedFile)file).getOriginalId());
                }
                return this.getId();
            }

            public long getOriginalFolderId() {
                if (file instanceof UserizedFile) {
                    return Long.parseLong(((UserizedFile)file).getOriginalFolderId());
                }
                return this.getFolderId();
            }
        };
        return metaData;
    }

    public int getOriginalId() {
        if (this.file instanceof UserizedFile) {
            return Integer.parseInt(((UserizedFile)this.file).getOriginalId());
        }
        return this.getId();
    }

    public void setOriginalId(int id) {
        if (this.file instanceof UserizedFile) {
            ((UserizedFile)this.file).setOriginalId(Integer.toString(id));
        }
    }

    public long getOriginalFolderId() {
        if (this.file instanceof UserizedFile) {
            return Long.parseLong(((UserizedFile)this.file).getOriginalFolderId());
        }
        return this.getFolderId();
    }

    public void setOriginalFolderId(long id) {
        if (this.file instanceof UserizedFile) {
            ((UserizedFile)this.file).setOriginalFolderId(Long.toString(id));
        }
    }
}

