/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive;

import com.openexchange.java.Strings;

public enum DriveClientType {
    UNKNOWN(null, true),
    WINDOWS("OpenXchange.HTTPClient.OXDrive", true),
    MAC_OS("OSX.OXDrive", true),
    IOS("OpenXchange.iosClient.OXDrive", false),
    ANDROID("OpenXchange.Android.OXDrive", false),
    TEST_DRIVE("OpenXchange.HTTPClient.TestDrive", true);

    private String clientString;
    private boolean desktop;

    private DriveClientType(String clientString, boolean desktop) {
        this.clientString = clientString;
        this.desktop = desktop;
    }

    public String getClientString() {
        return this.clientString;
    }

    public boolean isDesktop() {
        return this.desktop;
    }

    public static DriveClientType parse(String clientString) {
        if (!Strings.isEmpty((String)clientString)) {
            for (DriveClientType driveClient : DriveClientType.values()) {
                if (!clientString.equals(driveClient.clientString)) continue;
                return driveClient;
            }
        }
        return UNKNOWN;
    }
}

