/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.test.AjaxInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.TestCase;

public final class ResourceCreateTest
extends TestCase {
    private Context ctx;
    private User user;
    private User admin;
    private static final String SQL_DELETE = "DELETE FROM resource WHERE cid = ? AND id = ?";

    public ResourceCreateTest() {
    }

    public ResourceCreateTest(String name) {
        super(name);
    }

    private static Context resolveContext(String ctxStr) throws Exception {
        int pos = -1;
        pos = ctxStr.indexOf(64);
        String c = pos > -1 ? ctxStr.substring(pos + 1) : ctxStr;
        return ContextStorage.getStorageContext((int)ContextStorage.getInstance().getContextId(c));
    }

    private static User resolveUser(String user, Context ctx) throws Exception {
        int pos = -1;
        pos = user.indexOf(64);
        String u = pos > -1 ? user.substring(0, pos) : user;
        return UserStorage.getInstance().getUser(UserStorage.getInstance().getUserId(u, ctx), ctx);
    }

    protected void setUp() throws Exception {
        Init.startServer();
        String login = AjaxInit.getAJAXProperty("login");
        this.ctx = ResourceCreateTest.resolveContext(login);
        this.user = ResourceCreateTest.resolveUser(login, this.ctx);
        this.admin = UserStorage.getInstance().getUser(this.ctx.getMailadmin(), this.ctx);
    }

    protected void tearDown() throws Exception {
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceCreation() throws SQLException, OXException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresource@somewhere.com");
        resource.setSimpleName("M-T-R");
        int id = -1;
        try {
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, resource);
            id = resource.getIdentifier();
            ResourceCreateTest.assertTrue((String)("Invalid ID detected: " + id + ". ID has not been properly set through creation"), (id != -1 ? 1 : 0) != 0);
            ResourceCreateTest.assertTrue((String)("Invalid last-modified detected: " + resource.getLastModified() + ". Last-modified timestamp has not been properly set through creation"), (resource.getLastModified() != null && resource.getLastModified().getTime() < System.currentTimeMillis() ? 1 : 0) != 0);
        }
        finally {
            ResourceCreateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceCreationFail001() throws SQLException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresource@somewhere.com");
        resource.setSimpleName("M-T-R\u00f6\u00e4\u00fc");
        int id = -1;
        try {
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, resource);
            id = resource.getIdentifier();
            ResourceCreateTest.fail((String)"Creation succeeded with invalid string identifier");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceCreateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceCreationFail002() throws SQLException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresourcesomewhere.com");
        resource.setSimpleName("M-T-R");
        int id = -1;
        try {
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, resource);
            id = resource.getIdentifier();
            ResourceCreateTest.fail((String)"Creation succeeded with invalid email address");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceCreateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceCreationFail003() throws SQLException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresource@somewhere.com");
        resource.setSimpleName("M-T-R");
        Resource duplicate = new Resource();
        duplicate.setAvailable(true);
        duplicate.setDescription("My test resource");
        duplicate.setDisplayName("MyTestResource");
        duplicate.setMail("mytestresource2@somewhere.com");
        duplicate.setSimpleName("M-T-R");
        int id = -1;
        try {
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, resource);
            id = resource.getIdentifier();
            ResourceCreateTest.assertTrue((String)("Invalid identifier detected: " + id), (id != -1 ? 1 : 0) != 0);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, duplicate);
            ResourceCreateTest.fail((String)"Creation succeeded with duplicate identifier");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceCreateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceCreationFail004() throws SQLException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresource@somewhere.com");
        resource.setSimpleName("M-T-R");
        Resource duplicate = new Resource();
        duplicate.setAvailable(true);
        duplicate.setDescription("My test resource");
        duplicate.setDisplayName("MyTestResource");
        duplicate.setMail("mytestresource@somewhere.com");
        duplicate.setSimpleName("M-T-R2");
        int id = -1;
        try {
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, resource);
            id = resource.getIdentifier();
            ResourceCreateTest.assertTrue((String)("Invalid identifier detected: " + id), (id != -1 ? 1 : 0) != 0);
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, duplicate);
            ResourceCreateTest.fail((String)"Creation succeeded with duplicate email address");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceCreateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceFail007() throws SQLException {
        Resource resource = new Resource();
        resource.setAvailable(true);
        resource.setDescription("My test resource");
        resource.setDisplayName("MyTestResource");
        resource.setMail("mytestresource@somewhere.com");
        resource.setSimpleName(null);
        int id = -1;
        try {
            ((ResourceService)ServerServiceRegistry.getInstance().getService(ResourceService.class)).create(this.admin, this.ctx, resource);
            id = resource.getIdentifier();
            ResourceCreateTest.fail((String)"Creation succeeded with missing mandatory field");
        }
        catch (OXException oXException) {
        }
        finally {
            ResourceCreateTest.deleteResource(id, this.ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void deleteResource(int id, int cid) throws SQLException {
        Connection writeCon;
        if (-1 == id) {
            return;
        }
        try {
            writeCon = Database.get((int)cid, (boolean)true);
        }
        catch (OXException e) {
            e.printStackTrace();
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_DELETE);
            stmt.setInt(1, cid);
            stmt.setInt(2, id);
            stmt.executeUpdate();
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            Database.back((int)cid, (boolean)true, (Connection)writeCon);
        }
    }
}

