/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONObject;

public class MailPlainTextStructureTest
extends AbstractMailTest {
    private static final byte[] SIMPLE = "Return-Path: <user4@ox.microdoc.de>\nReceived: from ox.microdoc.de ([unix socket])\n                 by ox-p5 (Cyrus v2.2.13-Debian-2.2.13-10+etch2) with LMTPA;\n                 Sat, 14 Nov 2009 17:03:09 +0100\nReceived: from ox-p5 (localhost [127.0.0.1])\n                 by ox.microdoc.de (Postfix) with ESMTP id CD65A64F41\n                 for <user3@ox.microdoc.de>; Sat, 14 Nov 2009 17:03:09 +0100 (CET)\nDate: Sat, 14 Nov 2009 17:03:09 +0100 (CET)\nFrom: user5@ox.microdoc.de\nTo: user5@ox.microdoc.de\nMessage-ID: <1837640730.5.1258214590077.JavaMail.foobar@foobar>\nSubject: The mail subject\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\nX-Sieve: CMU Sieve 2.2\nX-Priority: 3\nX-Mailer: Open-Xchange Mailer v6.12.0-Rev3\nX-OX-Marker: 4936b5b2-d634-4c5a-b4e8-23f516a6f95e\n\nSOME-BASE64-DATA".getBytes();

    public MailPlainTextStructureTest() {
    }

    public MailPlainTextStructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailPlainTextStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            System.out.println(jsonMailObject.toString(2));
            Object bodyObject = jsonMailObject.opt("body");
            MailPlainTextStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailPlainTextStructureTest.assertTrue((String)"Body object is not a JSON object.", (boolean)(bodyObject instanceof JSONObject));
            JSONObject jsonBodyObject = (JSONObject)bodyObject;
            String id = jsonBodyObject.getString("id");
            MailPlainTextStructureTest.assertEquals((String)"Wring part ID.", (String)"1", (String)id);
            MailPlainTextStructureTest.assertNull((String)"Content-Tranfer-Encoding header is present, but shouldn't", (Object)jsonMailObject.getJSONObject("headers").opt("content-transfer-encoding"));
            JSONObject contentTypeJsonObject = jsonMailObject.getJSONObject("headers").getJSONObject("content-type");
            MailPlainTextStructureTest.assertNotNull((String)"Missing Content-Type header.", (Object)contentTypeJsonObject);
            MailPlainTextStructureTest.assertEquals((String)"Unexpected Content-Type.", (String)"text/plain", (String)contentTypeJsonObject.getString("type").toLowerCase());
            JSONObject parameterJsonObject = contentTypeJsonObject.getJSONObject("params");
            MailPlainTextStructureTest.assertEquals((String)"Unexpected charset.", (String)"utf-8", (String)parameterJsonObject.getString("charset").toLowerCase());
        }
        catch (Exception e) {
            e.printStackTrace();
            MailPlainTextStructureTest.fail((String)e.getMessage());
        }
    }
}

