/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.processing.MimeForward;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;

public final class MailBugfixTest
extends AbstractMailTest {
    private static final byte[] MAIL_BYTES = String.valueOf("Delivery-date: Tue, 21 Oct 2008 16:04:37 +0200\r\nMessage-ID: <48FDE207.60801@hostpoint.ch>\r\nDate: Tue, 21 Oct 2008 16:07:03 +0200\r\nFrom: Foo Bar <foo.bar@somewhere.com>\r\nUser-Agent: Thunderbird 2.0.0.0 (X11/20070326)\r\nMIME-Version: 1.0\r\nTo: Bar Foo <bar.foo@nowhere.org>\r\nSubject: Test Bildanhang\r\nContent-Type: multipart/mixed;\r\n boundary=\"------------080501040409070402000300\"\r\n\r\nThis is a multi-part message in MIME format.\r\n--------------080501040409070402000300\r\nContent-Type: text/plain; charset=ISO-8859-15; format=flowed\r\nContent-Transfer-Encoding: 7bit\r\n\r\nMore phun!\r\n\r\n--------------080501040409070402000300\r\nContent-Type: image/png;\r\nname=\"hostpoint.png\"\r\nContent-Transfer-Encoding: base64\r\nContent-Disposition: inline;\r\n filename=\"hostpoint.png\"\r\n\r\niVBORw0KGgoAAAANSUhEUgAAAFAAAAAPCAIAAAD8q9/YAAAA7klEQVRIieVXOw7DIAw1ETfK\r\nncycJQMHyMDCTO/UKzUdLFHCP6hJ2vAm2zLmvRgZwhARegIHAGPM1TROghCCk8Uez3zqiqPS\r\n8nhKB2KeFgAYrqZxNrjrrDiGGcXm/xf8Dg9bFNfTOXENsl3XRtzkjBstktooUyEKX9Jri+L6\r\nEPO0KC2Vli4bitgpQIY7FFJLohrCYFgwBe75XldrNBe/q+WdIVRMCAu2DVFfcENXaeO8bJuT\r\nYrmXfar5RXyhwykqVoNlVq+q5lC0aWaIaIyhUZyZ0ve4hz8PD8LNbqAoen14RA+zh7Yh8Wtg\r\nvf0tvQHWlp1rhK+ZbQAAAABJRU5ErkJggg==\r\n--------------080501040409070402000300--\r\n").getBytes();
    private static final String INBOX = "INBOX";
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};

    public MailBugfixTest() {
    }

    public MailBugfixTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug12357() {
        try {
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])MAIL_BYTES);
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                String[] uids = mailAccess.getMessageStorage().appendMessages(INBOX, new MailMessage[]{mail});
                try {
                    UserSettingMail usm = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId());
                    usm.setNoSave(true);
                    usm.setForwardAsAttachment(false);
                    MailMessage forwardMail = MimeForward.getFowardMail((MailMessage[])new MailMessage[]{mail}, (Session)session, (int)mailAccess.getAccountId(), (UserSettingMail)usm, (boolean)false);
                    int count = forwardMail.getEnclosedCount();
                    MailBugfixTest.assertFalse((String)"Forward message has no enclosed parts", (count == -1 ? 1 : 0) != 0);
                    MailBugfixTest.assertEquals((String)"Forward message has no enclosed parts", (int)2, (int)count);
                    MailPart imgPart = forwardMail.getEnclosedMailPart(1);
                    MailBugfixTest.assertFalse((String)"Forward message's image part is null", (imgPart == null ? 1 : 0) != 0);
                    MailBugfixTest.assertTrue((String)"Unexpected image part content-type", (boolean)imgPart.getContentType().getBaseType().equalsIgnoreCase("image/png"));
                }
                finally {
                    mailAccess.getMessageStorage().deleteMessages(INBOX, uids, true);
                }
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailBugfixTest.fail((String)e.getMessage());
        }
    }
}

