/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.folder;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.folder.FolderTestCase;
import com.openexchange.groupware.impl.FolderLock;
import com.openexchange.groupware.impl.FolderLockManager;
import com.openexchange.groupware.impl.FolderLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.session.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class FolderLockManagerTest
extends FolderTestCase {
    private FolderLockManager lockManager;
    private final List<Integer> clean = new ArrayList<Integer>();
    private int entity = 23;
    private int entityDepth1 = 24;
    private int entityDepth2 = 25;
    private static final long MILLIS_WEEK = 604800000L;
    private static final long MILLIS_YEAR = 31449600000L;
    private static final long MILLIS_10_YEARS = 314496000000L;
    private final List<Integer> unlock = new ArrayList<Integer>();
    private final Random r = new Random();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        this.lockManager = new FolderLockManagerImpl((DBProvider)new DBPoolProvider());
        this.lockManager.startTransaction();
        this.entity = this.mkdir(15, "folder" + this.r.nextInt()).getObjectID();
        this.clean.add(this.entity);
        this.entityDepth1 = this.mkdir(this.entity, "subfolder").getObjectID();
        this.entityDepth2 = this.mkdir(this.entityDepth1, "subsubfolder").getObjectID();
    }

    @Override
    public void tearDown() throws Exception {
        for (int id : this.unlock) {
            this.lockManager.unlock(id, (Session)this.session);
        }
        this.lockManager.commit();
        this.lockManager.finish();
        Init.stopServer();
        super.tearDown();
    }

    public void testExclusiveLock() throws Exception {
    }

    public void testSharedLock() throws Exception {
    }

    public void testFindDepth0Locks() throws Exception {
        int lockId = this.lockManager.lock(this.entity, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, 0, "Me", this.ctx, this.user);
        this.unlock.add(lockId);
        List locks = this.lockManager.findFolderLocks(this.entity, this.ctx, this.user);
        FolderLockManagerTest.assertEquals((int)1, (int)locks.size());
        Lock lock = (Lock)locks.get(0);
        FolderLockManagerTest.assertEquals((int)lockId, (int)lock.getId());
        FolderLockManagerTest.assertEquals((int)this.user.getId(), (int)lock.getOwner());
        FolderLockManagerTest.assertTrue((314496000000L - lock.getTimeout() - System.currentTimeMillis() < 1000L ? 1 : 0) != 0);
        FolderLockManagerTest.assertEquals((Object)LockManager.Scope.EXCLUSIVE, (Object)lock.getScope());
        FolderLockManagerTest.assertEquals((Object)LockManager.Type.WRITE, (Object)lock.getType());
    }

    public void testFindDepth1Locks() throws Exception {
        int lockId = this.lockManager.lock(this.entity, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, 1, "Me", this.ctx, this.user);
        this.unlock.add(lockId);
        List locks = this.lockManager.findFolderLocks(this.entityDepth1, this.ctx, this.user);
        FolderLockManagerTest.assertEquals((int)1, (int)locks.size());
        Lock lock = (Lock)locks.get(0);
        FolderLockManagerTest.assertEquals((int)lockId, (int)lock.getId());
        FolderLockManagerTest.assertEquals((int)this.user.getId(), (int)lock.getOwner());
        FolderLockManagerTest.assertTrue((314496000000L - lock.getTimeout() - System.currentTimeMillis() < 1000L ? 1 : 0) != 0);
        FolderLockManagerTest.assertEquals((Object)LockManager.Scope.EXCLUSIVE, (Object)lock.getScope());
        FolderLockManagerTest.assertEquals((Object)LockManager.Type.WRITE, (Object)lock.getType());
    }

    public void testFindDepthInfinityLocks() throws Exception {
        int lockId = this.lockManager.lock(this.entity, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, -1, "Me", this.ctx, this.user);
        this.unlock.add(lockId);
        List locks = this.lockManager.findFolderLocks(this.entityDepth2, this.ctx, this.user);
        FolderLockManagerTest.assertEquals((int)1, (int)locks.size());
        Lock lock = (Lock)locks.get(0);
        FolderLockManagerTest.assertEquals((int)lockId, (int)lock.getId());
        FolderLockManagerTest.assertEquals((int)this.user.getId(), (int)lock.getOwner());
        FolderLockManagerTest.assertTrue((314496000000L - lock.getTimeout() - System.currentTimeMillis() < 1000L ? 1 : 0) != 0);
        FolderLockManagerTest.assertEquals((Object)LockManager.Scope.EXCLUSIVE, (Object)lock.getScope());
        FolderLockManagerTest.assertEquals((Object)LockManager.Type.WRITE, (Object)lock.getType());
    }

    public void testLoadOwnLocks() throws Exception {
        int lockId = this.lockManager.lock(this.entity, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, -1, "Me", this.ctx, this.user);
        this.unlock.add(lockId);
        int lockId2 = this.lockManager.lock(this.entityDepth1, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, 0, "Me", this.ctx, this.user);
        this.unlock.add(lockId2);
        Map lockMap = this.lockManager.loadOwnLocks(Arrays.asList(this.entity, this.entityDepth1, this.entityDepth2), this.ctx, this.user);
        FolderLockManagerTest.assertTrue((boolean)((List)lockMap.get(this.entityDepth2)).isEmpty());
        FolderLockManagerTest.assertEquals((int)1, (int)((List)lockMap.get(this.entityDepth1)).size());
        FolderLockManagerTest.assertEquals((int)lockId2, (int)((FolderLock)((List)lockMap.get(this.entityDepth1)).get(0)).getId());
        FolderLockManagerTest.assertEquals((int)1, (int)((List)lockMap.get(this.entity)).size());
        FolderLockManagerTest.assertEquals((int)lockId, (int)((FolderLock)((List)lockMap.get(this.entity)).get(0)).getId());
    }

    public void testUnlock() throws Exception {
        int lockId = this.lockManager.lock(this.entity, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, 0, "Me", this.ctx, this.user);
        this.unlock.add(lockId);
        this.lockManager.unlock(lockId, (Session)this.session);
        List locks = this.lockManager.findFolderLocks(this.entity, this.ctx, this.user);
        FolderLockManagerTest.assertTrue((boolean)locks.isEmpty());
    }

    public void testTimeout() throws Exception {
        int lockId = this.lockManager.lock(this.entity, -23L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, 0, "Me", this.ctx, this.user);
        this.unlock.add(lockId);
        List locks = this.lockManager.findFolderLocks(this.entity, this.ctx, this.user);
        FolderLockManagerTest.assertEquals((int)0, (int)locks.size());
    }
}

