/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.reports;

import com.openexchange.dav.PropertyNames;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.junit.Assert;

public class SyncCollectionResponse {
    private final MultiStatusResponse[] responses;
    private final String syncToken;

    public SyncCollectionResponse(MultiStatus multiStatus, String syncToken) {
        this.responses = multiStatus.getResponses();
        this.syncToken = syncToken;
    }

    public String getSyncToken() {
        return this.syncToken;
    }

    public MultiStatusResponse[] getResponses() {
        return this.responses;
    }

    public Map<String, String> getETagsStatusOK() {
        HashMap<String, String> eTags = new HashMap<String, String>();
        for (MultiStatusResponse response : this.responses) {
            if (!response.getProperties(200).contains(PropertyNames.GETETAG)) continue;
            String href = response.getHref();
            Assert.assertNotNull((String)"got no href from response", (Object)href);
            Object value = response.getProperties(200).get(PropertyNames.GETETAG).getValue();
            Assert.assertNotNull((String)"got no ETag from response", (Object)value);
            String eTag = (String)value;
            eTags.put(href, eTag);
        }
        return eTags;
    }

    public List<String> getHrefsStatusNotFound() {
        ArrayList<String> hrefs = new ArrayList<String>();
        for (MultiStatusResponse response : this.responses) {
            if (null == response.getStatus() || 0 >= response.getStatus().length || null == response.getStatus()[0] || 404 != response.getStatus()[0].getStatusCode()) continue;
            hrefs.add(response.getHref());
        }
        return hrefs;
    }
}

