/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.UserAgents;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug38550Test
extends CardDAVTest {
    @Test
    public void testCreateInOtherFolder() throws Exception {
        for (String userAgent : UserAgents.IOS_ALL) {
            this.testCreateInOtherFolder(userAgent);
        }
    }

    private void testCreateInOtherFolder(String userAgent) throws Exception {
        this.getWebDAVClient().setUserAgent(userAgent);
        String gabCollection = String.valueOf(6);
        String defaultCollection = String.valueOf(this.getDefaultFolderID());
        String gabSyncToken = this.fetchSyncToken(gabCollection);
        String defaultSyncToken = this.fetchSyncToken(defaultCollection);
        String uid = Bug38550Test.randomUID();
        String firstName = "test";
        String lastName = "test";
        String url = "http://";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "URL:" + url + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.1//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putVCard(uid, vCard, gabCollection));
        Contact contact = this.getContact(uid);
        this.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"url wrong", (Object)url, (Object)contact.getURL());
        Assert.assertEquals((String)"folder wrong", (long)this.getDefaultFolderID(), (long)contact.getParentFolderID());
        Map<String, String> eTags = this.syncCollection(gabCollection, gabSyncToken);
        Assert.assertTrue((String)"resource changes reported on sync collection", (0 == eTags.size() ? 1 : 0) != 0);
        eTags = super.syncCollection(defaultCollection, defaultSyncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = this.addressbookMultiget(defaultCollection, eTags.keySet());
        VCardResource card = Bug38550Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)card.getFN());
        Assert.assertNotNull((String)"URL wrong", card.getVCard().getUrls().get(0));
    }
}

