/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug28672Test
extends CardDAVTest {
    @Test
    public void testImportVCard() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug28672Test.randomUID() + "-ABSPlugin";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:sdfsd;sdfsdf;;kulesh;\r\nFN:kulesh sdfsdf sdfsd\r\nEMAIL;type=INTERNET;type=WORK;type=pref:sdf@gmail.com\r\nNOTE:X-OPEN-XCHANGE-CTYPE\\: contact\r\nX-ABUID:4D863654-A664-4196-AFAF-0C3F93F07F12\\:ABPerson\r\nUID:" + uid + "\r\n" + "REV:2013-09-03T06:01:39Z" + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        Bug28672Test.assertContains(uid, addressData);
    }
}

