/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug21794Test
extends CalDAVTest {
    @Test
    public void testDeclineImportedAppointment() throws Exception {
        String uid = "WEBEX-MEETING CENTER-6.0292133-" + new Date().getTime();
        String resourceName = uid.replace(".", "");
        Date start = TimeTools.D("next monday at 15:30");
        Date end = TimeTools.D("next monday at 16:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//iCal 5.0.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Amsterdam\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Amsterdam:" + Bug21794Test.format(end, "Europe/Amsterdam") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "ORGANIZER;CN=\"webex\":MAILTO:messenger@example.com" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug21794Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:https://open-xchange.webex.com/open-xchange-en" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:Agorum Integration" + "\r\n" + "DTSTART;TZID=Europe/Amsterdam:" + Bug21794Test.format(start, "Europe/Amsterdam") + "\r\n" + "CREATED:" + Bug21794Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "ATTENDEE;CN=\"Open-Xchange Presenter\";CUTYPE=INDIVIDUAL;ROLE=REQ-PARTICIP" + "\r\n" + " ANT:MAILTO:webmeeting1@example.com" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(resourceName, iCal));
        Appointment appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = this.get(resourceName);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        List<SimpleICal.Property> attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        block0: for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            for (Map.Entry<String, String> attribute : property.getAttributes().entrySet()) {
                if (!attribute.getKey().equals("PARTSTAT")) continue;
                attribute.setValue("DECLINED");
                break block0;
            }
        }
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        UserParticipant[] users = appointment.getUsers();
        Assert.assertNotNull((String)"appointment has no users", (Object)users);
        UserParticipant declinedPartipant = null;
        for (UserParticipant user : users) {
            if (this.getAJAXClient().getValues().getUserId() != user.getIdentifier()) continue;
            declinedPartipant = user;
            break;
        }
        Assert.assertNotNull((String)"declining participant not found", declinedPartipant);
        Assert.assertEquals((String)"confirmation status wrong", (long)2L, (long)declinedPartipant.getConfirm());
        iCalResource = super.get(resourceName);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        SimpleICal.Property attendee = null;
        attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            attendee = property;
            break;
        }
        Assert.assertNotNull((String)"declining attendee not found", attendee);
        Assert.assertEquals((String)"partstat status wrong", (Object)"DECLINED", (Object)attendee.getAttribute("PARTSTAT"));
    }
}

