/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.task.actions.AbstractTaskRequest;
import com.openexchange.ajax.task.actions.GetParser;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.ArrayList;
import java.util.TimeZone;

public class GetRequest
extends AbstractTaskRequest<GetResponse> {
    private final int folderId;
    private final int taskId;
    private final TimeZone timeZone;
    private final boolean failOnError;

    public GetRequest(int folderId, int taskId, boolean failOnError) {
        this.folderId = folderId;
        this.taskId = taskId;
        this.timeZone = null;
        this.failOnError = failOnError;
    }

    public GetRequest(int folderId, int taskId, TimeZone timeZone, boolean failOnError) {
        this.folderId = folderId;
        this.taskId = taskId;
        this.timeZone = timeZone;
        this.failOnError = failOnError;
    }

    public GetRequest(InsertResponse insert) {
        this(insert.getFolderId(), insert.getId());
    }

    public GetRequest(int folderId, int taskId) {
        this(folderId, taskId, true);
    }

    public GetRequest(Task task) {
        this(task.getParentFolderID(), task.getObjectID());
    }

    public GetRequest(Task task, TimeZone timeZone) {
        this(task.getParentFolderID(), task.getObjectID(), timeZone, true);
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> retval = new ArrayList<AJAXRequest.Parameter>(4);
        retval.add(new AJAXRequest.Parameter("action", "get"));
        retval.add(new AJAXRequest.Parameter("folder", this.folderId));
        retval.add(new AJAXRequest.Parameter("id", this.taskId));
        if (null != this.timeZone) {
            retval.add(new AJAXRequest.Parameter("timezone", this.timeZone.getID()));
        }
        return retval.toArray(new AJAXRequest.Parameter[retval.size()]);
    }

    public GetParser getParser() {
        return new GetParser(this.failOnError);
    }
}

