/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class DateTimeTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private TimeZone timeZone;
    private List<Task> tasksToDelete;

    public DateTimeTest(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.tasksToDelete = new ArrayList<Task>();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        if (null != this.client && null != this.tasksToDelete) {
            int folderID = this.client.getValues().getPrivateTaskFolder();
            HashSet<Integer> ids = new HashSet<Integer>();
            for (Task task : this.tasksToDelete) {
                if (folderID != task.getParentFolderID()) {
                    this.client.execute(new DeleteRequest(task));
                    continue;
                }
                ids.add(task.getObjectID());
            }
            if (0 < ids.size()) {
                this.client.execute(new DeleteRequest(folderID, Autoboxing.I2i(ids), new Date(Long.MAX_VALUE), false));
            }
        }
        super.tearDown();
    }

    @Test
    public void testCreateWithLegacyClient() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("09.10.2014 00:00", TimeZone.getTimeZone("UTC")));
        task.setEndDate(TimeTools.D("13.10.2014 00:00", TimeZone.getTimeZone("UTC")));
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testCreateWithLegacyClient");
        this.client.execute(new InsertRequest(task, this.timeZone)).fillTask(task);
        this.tasksToDelete.add(task);
        GetResponse getResponse = this.client.execute(new GetRequest(task));
        Task legacyTask = getResponse.getTask(this.timeZone, true);
        DateTimeTest.assertNotNull((String)"No task created", (Object)legacyTask);
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)legacyTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)legacyTask.getEndDate());
        Task newTask = getResponse.getTask(this.timeZone, false);
        DateTimeTest.assertNotNull((String)"No task created", (Object)newTask);
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)newTask.getFullTime());
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)newTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)newTask.getEndDate());
        JSONObject data = (JSONObject)getResponse.getData();
        DateTimeTest.assertTrue((String)"No fulltime", (boolean)data.hasAndNotNull("full_time"));
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)data.getBoolean("full_time"));
        DateTimeTest.assertTrue((String)"No start time", (boolean)data.hasAndNotNull("start_time"));
        DateTimeTest.assertEquals((String)"Start time wrong", (long)task.getStartDate().getTime(), (long)data.getLong("start_time"));
        DateTimeTest.assertTrue((String)"No end time", (boolean)data.hasAndNotNull("end_time"));
        DateTimeTest.assertEquals((String)"End time wrong", (long)task.getEndDate().getTime(), (long)data.getLong("end_time"));
        DateTimeTest.assertTrue((String)"No start date", (boolean)data.hasAndNotNull("start_date"));
        DateTimeTest.assertEquals((String)"Start date wrong", (long)task.getStartDate().getTime(), (long)data.getLong("start_date"));
        DateTimeTest.assertTrue((String)"No end date", (boolean)data.hasAndNotNull("end_date"));
        DateTimeTest.assertEquals((String)"End date wrong", (long)task.getEndDate().getTime(), (long)data.getLong("end_date"));
    }

    @Test
    public void testCreateWithNewClient() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("11.11.2014 11:11", this.timeZone));
        task.setEndDate(TimeTools.D("12.11.2014 04:00", this.timeZone));
        task.setFullTime(false);
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testCreateWithNewClient");
        this.client.execute(new InsertRequest(task, this.timeZone, false, true, false)).fillTask(task);
        this.tasksToDelete.add(task);
        GetResponse getResponse = this.client.execute(new GetRequest(task));
        Task legacyTask = getResponse.getTask(this.timeZone, true);
        DateTimeTest.assertNotNull((String)"No task created", (Object)legacyTask);
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)legacyTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)legacyTask.getEndDate());
        Task newTask = getResponse.getTask(this.timeZone, false);
        DateTimeTest.assertNotNull((String)"No task created", (Object)newTask);
        DateTimeTest.assertFalse((String)"Fulltime wrong", (boolean)newTask.getFullTime());
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)newTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)newTask.getEndDate());
        JSONObject data = (JSONObject)getResponse.getData();
        DateTimeTest.assertTrue((String)"No fulltime", (boolean)data.hasAndNotNull("full_time"));
        DateTimeTest.assertFalse((String)"Fulltime wrong", (boolean)data.getBoolean("full_time"));
        DateTimeTest.assertTrue((String)"No start time", (boolean)data.hasAndNotNull("start_time"));
        DateTimeTest.assertEquals((String)"Start time wrong", (long)(task.getStartDate().getTime() + (long)this.timeZone.getOffset(task.getStartDate().getTime())), (long)data.getLong("start_time"));
        DateTimeTest.assertTrue((String)"No end time", (boolean)data.hasAndNotNull("end_time"));
        DateTimeTest.assertEquals((String)"End time wrong", (long)(task.getEndDate().getTime() + (long)this.timeZone.getOffset(task.getEndDate().getTime())), (long)data.getLong("end_time"));
        DateTimeTest.assertTrue((String)"No start date", (boolean)data.hasAndNotNull("start_date"));
        DateTimeTest.assertEquals((String)"Start date wrong", (long)task.getStartDate().getTime(), (long)data.getLong("start_date"));
        DateTimeTest.assertTrue((String)"No end date", (boolean)data.hasAndNotNull("end_date"));
        DateTimeTest.assertEquals((String)"End date wrong", (long)task.getEndDate().getTime(), (long)data.getLong("end_date"));
    }

    @Test
    public void testCreateFulltimeWithNewClient() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("20.12.2014 00:00", TimeZone.getTimeZone("UTC")));
        task.setEndDate(TimeTools.D("23.12.2014 00:00", TimeZone.getTimeZone("UTC")));
        task.setFullTime(true);
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testCreateFulltimeWithNewClient");
        this.client.execute(new InsertRequest(task, this.timeZone, false, true, false)).fillTask(task);
        this.tasksToDelete.add(task);
        GetResponse getResponse = this.client.execute(new GetRequest(task));
        Task legacyTask = getResponse.getTask(this.timeZone, true);
        DateTimeTest.assertNotNull((String)"No task created", (Object)legacyTask);
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)legacyTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)legacyTask.getEndDate());
        Task newTask = getResponse.getTask(this.timeZone, false);
        DateTimeTest.assertNotNull((String)"No task created", (Object)newTask);
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)newTask.getFullTime());
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)newTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)newTask.getEndDate());
        JSONObject data = (JSONObject)getResponse.getData();
        DateTimeTest.assertTrue((String)"No fulltime", (boolean)data.hasAndNotNull("full_time"));
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)data.getBoolean("full_time"));
        DateTimeTest.assertTrue((String)"No start time", (boolean)data.hasAndNotNull("start_time"));
        DateTimeTest.assertEquals((String)"Start time wrong", (long)task.getStartDate().getTime(), (long)data.getLong("start_time"));
        DateTimeTest.assertTrue((String)"No end time", (boolean)data.hasAndNotNull("end_time"));
        DateTimeTest.assertEquals((String)"End time wrong", (long)task.getEndDate().getTime(), (long)data.getLong("end_time"));
        DateTimeTest.assertTrue((String)"No start date", (boolean)data.hasAndNotNull("start_date"));
        DateTimeTest.assertEquals((String)"Start date wrong", (long)task.getStartDate().getTime(), (long)data.getLong("start_date"));
        DateTimeTest.assertTrue((String)"No end date", (boolean)data.hasAndNotNull("end_date"));
        DateTimeTest.assertEquals((String)"End date wrong", (long)task.getEndDate().getTime(), (long)data.getLong("end_date"));
    }

    @Test
    public void testCreateWithBrokenLegacyClient() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("22.10.2014 07:00", TimeZone.getTimeZone("UTC")));
        task.setEndDate(TimeTools.D("25.10.2014 14:00", TimeZone.getTimeZone("UTC")));
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testCreateWithBrokenLegacyClient");
        this.client.execute(new InsertRequest(task, this.timeZone)).fillTask(task);
        this.tasksToDelete.add(task);
        GetResponse getResponse = this.client.execute(new GetRequest(task));
        Task legacyTask = getResponse.getTask(this.timeZone, true);
        DateTimeTest.assertNotNull((String)"No task created", (Object)legacyTask);
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)legacyTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)legacyTask.getEndDate());
        Task newTask = getResponse.getTask(this.timeZone, false);
        DateTimeTest.assertNotNull((String)"No task created", (Object)newTask);
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)newTask.getFullTime());
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)TimeTools.D("22.10.2014 00:00", TimeZone.getTimeZone("UTC")), (Object)newTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)TimeTools.D("25.10.2014 00:00", TimeZone.getTimeZone("UTC")), (Object)newTask.getEndDate());
        JSONObject data = (JSONObject)getResponse.getData();
        DateTimeTest.assertTrue((String)"No fulltime", (boolean)data.hasAndNotNull("full_time"));
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)data.getBoolean("full_time"));
        DateTimeTest.assertTrue((String)"No start time", (boolean)data.hasAndNotNull("start_time"));
        DateTimeTest.assertEquals((String)"Start time wrong", (long)TimeTools.D("22.10.2014 00:00", TimeZone.getTimeZone("UTC")).getTime(), (long)data.getLong("start_time"));
        DateTimeTest.assertTrue((String)"No end time", (boolean)data.hasAndNotNull("end_time"));
        DateTimeTest.assertEquals((String)"End time wrong", (long)TimeTools.D("25.10.2014 00:00", TimeZone.getTimeZone("UTC")).getTime(), (long)data.getLong("end_time"));
        DateTimeTest.assertTrue((String)"No start date", (boolean)data.hasAndNotNull("start_date"));
        DateTimeTest.assertEquals((String)"Start date wrong", (long)task.getStartDate().getTime(), (long)data.getLong("start_date"));
        DateTimeTest.assertTrue((String)"No end date", (boolean)data.hasAndNotNull("end_date"));
        DateTimeTest.assertEquals((String)"End date wrong", (long)task.getEndDate().getTime(), (long)data.getLong("end_date"));
    }

    @Test
    public void testUpdateWithLegacyClient() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("05.11.2014 20:00", this.timeZone));
        task.setEndDate(TimeTools.D("05.11.2014 21:00", this.timeZone));
        task.setFullTime(false);
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testUpdateWithLegacyClient");
        this.client.execute(new InsertRequest(task, this.timeZone, false, true, false)).fillTask(task);
        this.tasksToDelete.add(task);
        Task toUpdate = new Task();
        toUpdate.setObjectID(task.getObjectID());
        toUpdate.setParentFolderID(task.getParentFolderID());
        toUpdate.setLastModified(task.getLastModified());
        toUpdate.setStartDate(TimeTools.D("05.11.2014 00:00", TimeZone.getTimeZone("UTC")));
        toUpdate.setEndDate(TimeTools.D("06.11.2014 00:00", TimeZone.getTimeZone("UTC")));
        UpdateResponse updateResponse = this.client.execute(new UpdateRequest(toUpdate, this.timeZone));
        DateTimeTest.assertFalse((String)"Errors in response", (boolean)updateResponse.hasError());
        GetResponse getResponse = this.client.execute(new GetRequest(task));
        Task legacyTask = getResponse.getTask(this.timeZone, true);
        DateTimeTest.assertNotNull((String)"No task created", (Object)legacyTask);
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)toUpdate.getStartDate(), (Object)legacyTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)toUpdate.getEndDate(), (Object)legacyTask.getEndDate());
        Task newTask = getResponse.getTask(this.timeZone, false);
        DateTimeTest.assertNotNull((String)"No task created", (Object)newTask);
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)newTask.getFullTime());
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)toUpdate.getStartDate(), (Object)newTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)toUpdate.getEndDate(), (Object)newTask.getEndDate());
        JSONObject data = (JSONObject)getResponse.getData();
        DateTimeTest.assertTrue((String)"No fulltime", (boolean)data.hasAndNotNull("full_time"));
        DateTimeTest.assertTrue((String)"Fulltime wrong", (boolean)data.getBoolean("full_time"));
        DateTimeTest.assertTrue((String)"No start time", (boolean)data.hasAndNotNull("start_time"));
        DateTimeTest.assertEquals((String)"Start time wrong", (long)toUpdate.getStartDate().getTime(), (long)data.getLong("start_time"));
        DateTimeTest.assertTrue((String)"No end time", (boolean)data.hasAndNotNull("end_time"));
        DateTimeTest.assertEquals((String)"End time wrong", (long)toUpdate.getEndDate().getTime(), (long)data.getLong("end_time"));
        DateTimeTest.assertTrue((String)"No start date", (boolean)data.hasAndNotNull("start_date"));
        DateTimeTest.assertEquals((String)"Start date wrong", (long)toUpdate.getStartDate().getTime(), (long)data.getLong("start_date"));
        DateTimeTest.assertTrue((String)"No end date", (boolean)data.hasAndNotNull("end_date"));
        DateTimeTest.assertEquals((String)"End date wrong", (long)toUpdate.getEndDate().getTime(), (long)data.getLong("end_date"));
    }

    @Test
    public void testUpdateWithNewClient() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("23.10.2014 00:00", TimeZone.getTimeZone("UTC")));
        task.setEndDate(TimeTools.D("23.10.2014 00:00", TimeZone.getTimeZone("UTC")));
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testUpdateWithNewClient");
        this.client.execute(new InsertRequest(task, this.timeZone)).fillTask(task);
        this.tasksToDelete.add(task);
        Task toUpdate = new Task();
        toUpdate.setObjectID(task.getObjectID());
        toUpdate.setParentFolderID(task.getParentFolderID());
        toUpdate.setLastModified(task.getLastModified());
        toUpdate.setStartDate(TimeTools.D("23.10.2014 08:00", this.timeZone));
        toUpdate.setEndDate(TimeTools.D("24.10.2014 18:00", this.timeZone));
        toUpdate.setFullTime(false);
        UpdateResponse updateResponse = this.client.execute(new UpdateRequest(toUpdate, this.timeZone, true, false));
        DateTimeTest.assertFalse((String)"Errors in response", (boolean)updateResponse.hasError());
        GetResponse getResponse = this.client.execute(new GetRequest(task));
        Task legacyTask = getResponse.getTask(this.timeZone, true);
        DateTimeTest.assertNotNull((String)"No task created", (Object)legacyTask);
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)toUpdate.getStartDate(), (Object)legacyTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)toUpdate.getEndDate(), (Object)legacyTask.getEndDate());
        Task newTask = getResponse.getTask(this.timeZone, false);
        DateTimeTest.assertNotNull((String)"No task created", (Object)newTask);
        DateTimeTest.assertFalse((String)"Fulltime wrong", (boolean)newTask.getFullTime());
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)toUpdate.getStartDate(), (Object)newTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)toUpdate.getEndDate(), (Object)newTask.getEndDate());
        JSONObject data = (JSONObject)getResponse.getData();
        DateTimeTest.assertTrue((String)"No fulltime", (boolean)data.hasAndNotNull("full_time"));
        DateTimeTest.assertFalse((String)"Fulltime wrong", (boolean)data.getBoolean("full_time"));
        DateTimeTest.assertTrue((String)"No start time", (boolean)data.hasAndNotNull("start_time"));
        DateTimeTest.assertEquals((String)"Start time wrong", (long)(toUpdate.getStartDate().getTime() + (long)this.timeZone.getOffset(toUpdate.getStartDate().getTime())), (long)data.getLong("start_time"));
        DateTimeTest.assertTrue((String)"No end time", (boolean)data.hasAndNotNull("end_time"));
        DateTimeTest.assertEquals((String)"End time wrong", (long)(toUpdate.getEndDate().getTime() + (long)this.timeZone.getOffset(toUpdate.getEndDate().getTime())), (long)data.getLong("end_time"));
        DateTimeTest.assertTrue((String)"No start date", (boolean)data.hasAndNotNull("start_date"));
        DateTimeTest.assertEquals((String)"Start date wrong", (long)toUpdate.getStartDate().getTime(), (long)data.getLong("start_date"));
        DateTimeTest.assertTrue((String)"No end date", (boolean)data.hasAndNotNull("end_date"));
        DateTimeTest.assertEquals((String)"End date wrong", (long)toUpdate.getEndDate().getTime(), (long)data.getLong("end_date"));
    }

    @Test
    public void testUpdateOtherAttribute() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("28.10.2014 08:00", this.timeZone));
        task.setEndDate(TimeTools.D("01.11.2014 16:00", this.timeZone));
        task.setFullTime(false);
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testUpdateOtherAttribute");
        this.client.execute(new InsertRequest(task, this.timeZone, false, true, false)).fillTask(task);
        this.tasksToDelete.add(task);
        Task toUpdate = new Task();
        toUpdate.setObjectID(task.getObjectID());
        toUpdate.setParentFolderID(task.getParentFolderID());
        toUpdate.setLastModified(task.getLastModified());
        toUpdate.setNote("added notes");
        UpdateResponse updateResponse = this.client.execute(new UpdateRequest(toUpdate, this.timeZone));
        DateTimeTest.assertFalse((String)"Errors in response", (boolean)updateResponse.hasError());
        GetResponse getResponse = this.client.execute(new GetRequest(task));
        Task legacyTask = getResponse.getTask(this.timeZone, true);
        DateTimeTest.assertNotNull((String)"No task created", (Object)legacyTask);
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)legacyTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)legacyTask.getEndDate());
        DateTimeTest.assertEquals((String)"Note wrong", (String)toUpdate.getNote(), (String)legacyTask.getNote());
        Task newTask = getResponse.getTask(this.timeZone, false);
        DateTimeTest.assertNotNull((String)"No task created", (Object)newTask);
        DateTimeTest.assertFalse((String)"Fulltime wrong", (boolean)newTask.getFullTime());
        DateTimeTest.assertEquals((String)"Start date wrong", (Object)task.getStartDate(), (Object)newTask.getStartDate());
        DateTimeTest.assertEquals((String)"End date wrong", (Object)task.getEndDate(), (Object)newTask.getEndDate());
        DateTimeTest.assertEquals((String)"Note wrong", (String)toUpdate.getNote(), (String)newTask.getNote());
        JSONObject data = (JSONObject)getResponse.getData();
        DateTimeTest.assertTrue((String)"No fulltime", (boolean)data.hasAndNotNull("full_time"));
        DateTimeTest.assertFalse((String)"Fulltime wrong", (boolean)data.getBoolean("full_time"));
        DateTimeTest.assertTrue((String)"No start time", (boolean)data.hasAndNotNull("start_time"));
        DateTimeTest.assertEquals((String)"Start time wrong", (long)(task.getStartDate().getTime() + (long)this.timeZone.getOffset(task.getStartDate().getTime())), (long)data.getLong("start_time"));
        DateTimeTest.assertTrue((String)"No end time", (boolean)data.hasAndNotNull("end_time"));
        DateTimeTest.assertEquals((String)"End time wrong", (long)(task.getEndDate().getTime() + (long)this.timeZone.getOffset(task.getEndDate().getTime())), (long)data.getLong("end_time"));
        DateTimeTest.assertTrue((String)"No start date", (boolean)data.hasAndNotNull("start_date"));
        DateTimeTest.assertEquals((String)"Start date wrong", (long)task.getStartDate().getTime(), (long)data.getLong("start_date"));
        DateTimeTest.assertTrue((String)"No end date", (boolean)data.hasAndNotNull("end_date"));
        DateTimeTest.assertEquals((String)"End date wrong", (long)task.getEndDate().getTime(), (long)data.getLong("end_date"));
    }

    @Test
    public void testColumns() throws Exception {
        Task task = new Task();
        task.setStartDate(TimeTools.D("09.12.2014 19:15", this.timeZone));
        task.setEndDate(TimeTools.D("03.01.2015 14:00", this.timeZone));
        task.setFullTime(false);
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        task.setTitle("testUpdateOtherAttribute");
        this.client.execute(new InsertRequest(task, this.timeZone, false, true, false)).fillTask(task);
        this.tasksToDelete.add(task);
        int[][] folderAndTaskIDs = new int[][]{{task.getParentFolderID(), task.getObjectID()}};
        CommonListResponse listResponse = this.client.execute(new ListRequest((int[][])folderAndTaskIDs, new int[]{401}));
        Object value = listResponse.getValue(0, 401);
        DateTimeTest.assertTrue((String)"Wrong type for fulltime", (null != value && Boolean.class.isInstance(value) ? 1 : 0) != 0);
        DateTimeTest.assertFalse((String)"Fulltime wrong", (boolean)((Boolean)value));
        listResponse = this.client.execute(new ListRequest((int[][])folderAndTaskIDs, new int[]{201}));
        value = listResponse.getValue(0, 201);
        DateTimeTest.assertTrue((String)"Wrong type for start date", (null != value && Long.class.isInstance(value) ? 1 : 0) != 0);
        DateTimeTest.assertEquals((String)"Start date wrong", (long)task.getStartDate().getTime(), (long)((Long)value));
        listResponse = this.client.execute(new ListRequest((int[][])folderAndTaskIDs, new int[]{202}));
        value = listResponse.getValue(0, 202);
        DateTimeTest.assertTrue((String)"Wrong type for end date", (null != value && Long.class.isInstance(value) ? 1 : 0) != 0);
        DateTimeTest.assertEquals((String)"End date wrong", (long)task.getEndDate().getTime(), (long)((Long)value));
        listResponse = this.client.execute(new ListRequest((int[][])folderAndTaskIDs, new int[]{316}));
        value = listResponse.getValue(0, 316);
        DateTimeTest.assertTrue((String)"Wrong type for start time", (null != value && Long.class.isInstance(value) ? 1 : 0) != 0);
        DateTimeTest.assertEquals((String)"Start time time", (long)(task.getStartDate().getTime() + (long)this.timeZone.getOffset(task.getStartDate().getTime())), (long)((Long)value));
        listResponse = this.client.execute(new ListRequest((int[][])folderAndTaskIDs, new int[]{317}));
        value = listResponse.getValue(0, 317);
        DateTimeTest.assertTrue((String)"Wrong type for end time", (null != value && Long.class.isInstance(value) ? 1 : 0) != 0);
        DateTimeTest.assertEquals((String)"End time wrong", (long)(task.getEndDate().getTime() + (long)this.timeZone.getOffset(task.getEndDate().getTime())), (long)((Long)value));
    }
}

