/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.java.Autoboxing;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug33258Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private TimeZone timeZone;
    private Task task;

    public Bug33258Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.timeZone = this.client1.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client1.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 33258");
        this.client1.execute(new InsertRequest(this.task, this.timeZone)).fillTask(this.task);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.client1.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    @Test
    public void testForVerifiedPriority() throws OXException, IOException, JSONException {
        UpdateResponse response;
        Task test = TaskTools.valuesForUpdate(this.task);
        for (int priority : new int[]{1, 2, 3}) {
            test.setPriority(Autoboxing.I((int)priority));
            response = this.client1.execute(new UpdateRequest(test, this.timeZone, false));
            if (!response.hasError()) {
                test.setLastModified(response.getTimestamp());
                this.task.setLastModified(response.getTimestamp());
            }
            Bug33258Test.assertFalse((String)("Priority value " + priority + " should work."), (boolean)response.hasError());
            GetResponse getResponse = this.client1.execute(new GetRequest(test));
            test = getResponse.getTask(this.timeZone);
            Bug33258Test.assertTrue((String)"Task should contain a priority.", (boolean)test.containsPriority());
            Bug33258Test.assertEquals((String)"Written priority should be equal to read one.", (Object)Autoboxing.I((int)priority), (Object)test.getPriority());
        }
        for (int priority : new int[]{0, 4}) {
            test.setPriority(Autoboxing.I((int)priority));
            response = this.client1.execute(new UpdateRequest(test, this.timeZone, false));
            if (!response.hasError()) {
                test.setLastModified(response.getTimestamp());
                this.task.setLastModified(response.getTimestamp());
            }
            Bug33258Test.assertTrue((String)("Priority value " + priority + " should not work."), (boolean)response.hasError());
            Bug33258Test.assertTrue((String)"Did not get an exception about an invalid priority value.", (boolean)response.getException().similarTo(TaskExceptionCode.INVALID_PRIORITY.create(new Object[]{Autoboxing.I((int)priority)})));
        }
        test.removePriority();
        UpdateResponse response2 = this.client1.execute(new UpdateRequest(test, this.timeZone){

            @Override
            public JSONObject getBody() throws JSONException {
                JSONObject json = super.getBody();
                json.put("priority", JSONObject.NULL);
                return json;
            }
        });
        test.setLastModified(response2.getTimestamp());
        this.task.setLastModified(response2.getTimestamp());
        GetResponse getResponse = this.client1.execute(new GetRequest(test));
        test = getResponse.getTask(this.timeZone);
        Bug33258Test.assertFalse((String)"Task should not contain a priority.", (boolean)test.containsPriority());
    }
}

