/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.smtptest.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.mail.mime.MimeDefaultSession;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.Assert;

public class GetMailsResponse
extends AbstractAJAXResponse {
    protected GetMailsResponse(Response response) {
        super(response);
    }

    public List<Message> getMessages() throws JSONException, MessagingException {
        JSONObject json = ResponseWriter.getJSON((Response)this.getResponse());
        JSONArray jMessages = json.getJSONArray("data");
        ArrayList<Message> messages = new ArrayList<Message>(jMessages.length());
        for (int i = 0; i < jMessages.length(); ++i) {
            JSONObject jMessage = jMessages.getJSONObject(i);
            JSONArray jHeaders = jMessage.getJSONArray("headers");
            Message message = new Message(jMessage.getString("raw_message"));
            for (int j = 0; j < jHeaders.length(); ++j) {
                JSONObject jHeader = jHeaders.getJSONObject(j);
                message.setHeader(jHeader.getString("name"), jHeader.getString("value"));
            }
            messages.add(message);
        }
        return messages;
    }

    public static final class Message {
        private Document html;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final String rawMessage;
        private final MimeMessage mimeMessage;

        public Message(String rawMessage) throws MessagingException {
            this.rawMessage = rawMessage;
            this.mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new ByteArrayInputStream(rawMessage.getBytes()));
        }

        public String getRawMessage() {
            return this.rawMessage;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public MimeMessage getMimeMessage() {
            return this.mimeMessage;
        }

        public String requirePlainText() throws IOException, MessagingException {
            String text = this.getPlainText();
            Assert.assertNotNull((String)"MIME message did not contain a plain text part.", (Object)text);
            return text;
        }

        public String getPlainText() throws IOException, MessagingException {
            MimeMultipart multipart;
            BodyPart bodyPart;
            Object content = this.mimeMessage.getContent();
            if (content instanceof String) {
                return (String)content;
            }
            if (content instanceof InputStream) {
                return Message.readStream((InputStream)content);
            }
            if (content instanceof MimeMultipart && (bodyPart = this.findPartByContentType(multipart = (MimeMultipart)content, "text/plain")) != null) {
                return Message.readStream(bodyPart.getInputStream());
            }
            return null;
        }

        public Document requireHtml() throws IOException, MessagingException {
            Document document = this.getHtml();
            Assert.assertNotNull((String)"MIME message did not contain an HTML part.", (Object)document);
            return document;
        }

        public Document getHtml() throws IOException, MessagingException {
            MimeMultipart multipart;
            BodyPart bodyPart;
            Object content;
            if (this.html == null && (content = this.mimeMessage.getContent()) instanceof MimeMultipart && (bodyPart = this.findPartByContentType(multipart = (MimeMultipart)content, "text/html")) != null) {
                Document document;
                String readStream = Message.readStream(bodyPart.getInputStream());
                this.html = document = Jsoup.parse((String)readStream);
            }
            return this.html;
        }

        public BodyPart getBodyPartByContentType(String contentType) throws MessagingException, IOException {
            Object content = this.mimeMessage.getContent();
            if (content instanceof MimeMultipart) {
                return this.findPartByContentType((MimeMultipart)content, contentType);
            }
            return null;
        }

        public BodyPart getBodyPartByContentID(String cid) throws MessagingException, IOException {
            Object content = this.mimeMessage.getContent();
            if (content instanceof MimeMultipart) {
                return this.findPartByContentID((MimeMultipart)content, cid);
            }
            return null;
        }

        private BodyPart findPartByContentType(MimeMultipart multipart, String contentType) throws MessagingException, IOException {
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                if (bodyPart.getContentType().startsWith("multipart/")) {
                    return this.findPartByContentType((MimeMultipart)bodyPart.getContent(), contentType);
                }
                if (!bodyPart.getContentType().startsWith(contentType)) continue;
                return bodyPart;
            }
            return null;
        }

        private BodyPart findPartByContentID(MimeMultipart multipart, String cid) throws MessagingException, IOException {
            for (int i = 0; i < multipart.getCount(); ++i) {
                MimeBodyPart bodyPart = (MimeBodyPart)multipart.getBodyPart(i);
                if (cid.equals(bodyPart.getContentID())) {
                    return bodyPart;
                }
                if (!bodyPart.getContentType().startsWith("multipart/")) continue;
                return this.findPartByContentID((MimeMultipart)bodyPart.getContent(), cid);
            }
            return null;
        }

        private static String readStream(InputStream is) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line).append(System.getProperty("line.separator"));
                line = br.readLine();
            }
            br.close();
            return sb.toString();
        }

        static {
            MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            HashSet<String> types = new HashSet<String>(Arrays.asList(mc.getMimeTypes()));
            if (!types.contains("text/html")) {
                mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            }
            if (!types.contains("text/xml")) {
                mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            }
            if (!types.contains("text/plain")) {
                mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            }
            if (!types.contains("multipart/*")) {
                mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed; x-java-fallback-entry=true");
            }
            if (!types.contains("message/rfc822")) {
                mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            }
            CommandMap.setDefaultCommandMap((CommandMap)mc);
        }
    }
}

