/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.ajax.share.actions.ShareLink;
import com.openexchange.ajax.share.actions.UpdateLinkRequest;
import com.openexchange.ajax.share.actions.UpdateLinkResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.share.ShareTarget;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class LinkUpdateTest
extends ShareTest {
    public LinkUpdateTest(String name) {
        super(name);
    }

    public void testLinkExpiryDateRandomly() throws Exception {
        this.testLinkExpiryDate(LinkUpdateTest.randomFolderAPI(), LinkUpdateTest.randomModule());
    }

    public void noTestLinkExpiryDateExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testLinkExpiryDate(api, module);
            }
        }
    }

    private void testLinkExpiryDate(EnumAPI api, int module) throws Exception {
        this.testLinkExpiryDate(api, module, this.getDefaultFolder(module));
    }

    private void testLinkExpiryDate(EnumAPI api, int module, int parent) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, module, parent);
        ShareTarget target = new ShareTarget(module, String.valueOf(folder.getObjectID()));
        GetLinkResponse getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        ShareLink link = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no link", (Object)link);
        LinkUpdateTest.assertTrue((boolean)link.isNew());
        Date expiryDate = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
        UpdateLinkRequest updateRequest = new UpdateLinkRequest(target, this.getTimeZone(), getResponse.getTimestamp().getTime());
        updateRequest.setExpiryDate(expiryDate);
        UpdateLinkResponse updateResponse = this.client.execute(updateRequest);
        LinkUpdateTest.assertFalse((String)updateResponse.getErrorMessage(), (boolean)updateResponse.hasError());
        getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        ShareLink updatedLink = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no updated link", (Object)updatedLink);
        LinkUpdateTest.assertEquals((String)link.getShareURL(), (String)updatedLink.getShareURL());
        LinkUpdateTest.assertFalse((boolean)updatedLink.isNew());
        LinkUpdateTest.assertEquals((String)"expiry date wrong", (Object)expiryDate, (Object)updatedLink.getExpiry());
        expiryDate = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(3L));
        updateRequest = new UpdateLinkRequest(target, this.getTimeZone(), updateResponse.getTimestamp().getTime());
        updateRequest.setExpiryDate(expiryDate);
        updateResponse = this.client.execute(updateRequest);
        LinkUpdateTest.assertFalse((String)updateResponse.getErrorMessage(), (boolean)updateResponse.hasError());
        getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        updatedLink = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no updated link", (Object)updatedLink);
        LinkUpdateTest.assertEquals((String)link.getShareURL(), (String)updatedLink.getShareURL());
        LinkUpdateTest.assertFalse((boolean)updatedLink.isNew());
        LinkUpdateTest.assertEquals((String)"expiry date wrong", (Object)expiryDate, (Object)updatedLink.getExpiry());
        updateRequest = new UpdateLinkRequest(target, this.getTimeZone(), updateResponse.getTimestamp().getTime());
        updateRequest.setExpiryDate(null);
        updateResponse = this.client.execute(updateRequest);
        LinkUpdateTest.assertFalse((String)updateResponse.getErrorMessage(), (boolean)updateResponse.hasError());
        getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        updatedLink = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no updated link", (Object)updatedLink);
        LinkUpdateTest.assertEquals((String)link.getShareURL(), (String)updatedLink.getShareURL());
        LinkUpdateTest.assertFalse((boolean)updatedLink.isNew());
        LinkUpdateTest.assertEquals((String)"expiry date wrong", null, (Object)updatedLink.getExpiry());
    }

    public void testLinkPasswordRandomly() throws Exception {
        this.testLinkPassword(LinkUpdateTest.randomFolderAPI(), LinkUpdateTest.randomModule());
    }

    public void noTestPasswordExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testLinkPassword(api, module);
            }
        }
    }

    private void testLinkPassword(EnumAPI api, int module) throws Exception {
        this.testLinkPassword(api, module, this.getDefaultFolder(module));
    }

    private void testLinkPassword(EnumAPI api, int module, int parent) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, module, parent);
        ShareTarget target = new ShareTarget(module, String.valueOf(folder.getObjectID()));
        GetLinkResponse getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        ShareLink link = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no link", (Object)link);
        LinkUpdateTest.assertTrue((boolean)link.isNew());
        String password = LinkUpdateTest.randomUID();
        UpdateLinkRequest updateRequest = new UpdateLinkRequest(target, this.getTimeZone(), getResponse.getTimestamp().getTime());
        updateRequest.setPassword(password);
        UpdateLinkResponse updateResponse = this.client.execute(updateRequest);
        LinkUpdateTest.assertFalse((String)updateResponse.getErrorMessage(), (boolean)updateResponse.hasError());
        getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        ShareLink updatedLink = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no updated link", (Object)updatedLink);
        LinkUpdateTest.assertEquals((String)link.getShareURL(), (String)updatedLink.getShareURL());
        LinkUpdateTest.assertFalse((boolean)updatedLink.isNew());
        LinkUpdateTest.assertEquals((String)"password wrong", (String)password, (String)updatedLink.getPassword());
        password = LinkUpdateTest.randomUID();
        updateRequest = new UpdateLinkRequest(target, this.getTimeZone(), updateResponse.getTimestamp().getTime());
        updateRequest.setPassword(password);
        updateResponse = this.client.execute(updateRequest);
        LinkUpdateTest.assertFalse((String)updateResponse.getErrorMessage(), (boolean)updateResponse.hasError());
        getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        updatedLink = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no updated link", (Object)updatedLink);
        LinkUpdateTest.assertEquals((String)link.getShareURL(), (String)updatedLink.getShareURL());
        LinkUpdateTest.assertFalse((boolean)updatedLink.isNew());
        LinkUpdateTest.assertEquals((String)"password wrong", (String)password, (String)updatedLink.getPassword());
        updateRequest = new UpdateLinkRequest(target, this.getTimeZone(), updateResponse.getTimestamp().getTime());
        updateRequest.setPassword(null);
        updateResponse = this.client.execute(updateRequest);
        LinkUpdateTest.assertFalse((String)updateResponse.getErrorMessage(), (boolean)updateResponse.hasError());
        getResponse = this.client.execute(new GetLinkRequest(target, this.getTimeZone()));
        LinkUpdateTest.assertFalse((String)getResponse.getErrorMessage(), (boolean)getResponse.hasError());
        updatedLink = getResponse.getShareLink();
        LinkUpdateTest.assertNotNull((String)"got no updated link", (Object)updatedLink);
        LinkUpdateTest.assertEquals((String)link.getShareURL(), (String)updatedLink.getShareURL());
        LinkUpdateTest.assertFalse((boolean)updatedLink.isNew());
        LinkUpdateTest.assertEquals((String)"password wrong", null, (String)updatedLink.getPassword());
    }
}

