/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.RecipientType;

public class ConvertToInternalPermissionTest
extends ShareTest {
    public ConvertToInternalPermissionTest(String name) {
        super(name);
    }

    public void testConvertToInternalPermissionRandomly() throws Exception {
        this.testConvertToInternalPermission(ConvertToInternalPermissionTest.randomFolderAPI(), ConvertToInternalPermissionTest.randomModule(), AJAXClient.User.User3);
    }

    public void noTestConvertToInternalPermissionExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testConvertToInternalPermission(api, module, AJAXClient.User.User3);
            }
        }
    }

    public void testConvertToInternalObjectPermissionRandomly() throws Exception {
        this.testConvertToInternalObjectPermission(ConvertToInternalPermissionTest.randomFolderAPI(), AJAXClient.User.User3);
    }

    private void testConvertToInternalPermission(EnumAPI api, int module, AJAXClient.User user) throws Exception {
        this.testConvertToInternalPermission(api, module, this.getDefaultFolder(module), user);
    }

    private void testConvertToInternalPermission(EnumAPI api, int module, int parent, AJAXClient.User user) throws Exception {
        AJAXClient userClient = new AJAXClient(user);
        String email = userClient.getValues().getDefaultAddress();
        int userID = userClient.getValues().getUserId();
        OCLGuestPermission guestPermission = ConvertToInternalPermissionTest.createNamedGuestPermission(email, "", AJAXConfig.getProperty(user.getPassword()));
        userClient.logout();
        FolderObject folder = this.insertSharedFolder(api, module, parent, guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() != userID) continue;
            matchingPermission = permission;
            break;
        }
        ConvertToInternalPermissionTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        ConvertToInternalPermissionTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity entity = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        ConvertToInternalPermissionTest.assertEquals((Object)RecipientType.USER, (Object)entity.getType());
    }

    private void testConvertToInternalObjectPermission(EnumAPI api, AJAXClient.User user) throws Exception {
        this.testConvertToInternalObjectPermission(api, this.getDefaultFolder(8), user);
    }

    private void testConvertToInternalObjectPermission(EnumAPI api, int parent, AJAXClient.User user) throws Exception {
        AJAXClient userClient = new AJAXClient(user);
        String email = userClient.getValues().getDefaultAddress();
        int userID = userClient.getValues().getUserId();
        FileStorageGuestObjectPermission guestPermission = ConvertToInternalPermissionTest.asObjectPermission(ConvertToInternalPermissionTest.createNamedGuestPermission(email, "", AJAXConfig.getProperty(user.getPassword())));
        userClient.logout();
        byte[] contents = new byte[64 + random.nextInt(256)];
        random.nextBytes(contents);
        String filename = ConvertToInternalPermissionTest.randomUID();
        FolderObject folder = this.insertPrivateFolder(api, 8, parent);
        File file = this.insertSharedFile(folder.getObjectID(), filename, (FileStorageObjectPermission)guestPermission, contents);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() != userID) continue;
            matchingPermission = permission;
            break;
        }
        ConvertToInternalPermissionTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        ConvertToInternalPermissionTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity entity = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        ConvertToInternalPermissionTest.assertEquals((Object)RecipientType.USER, (Object)entity.getType());
    }
}

