/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.java.Strings;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;

public class BasicAuthTest
extends ShareTest {
    private CalendarTestManager calendarManager;
    private FolderObject folder;

    public BasicAuthTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.calendarManager = new CalendarTestManager(this.client);
    }

    @Override
    protected void tearDown() throws Exception {
        CalendarTestManager calendarManager = this.calendarManager;
        if (null != calendarManager) {
            calendarManager.cleanUp();
            this.calendarManager = null;
        }
        if (null != this.folder) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OX_OLD, false, this.folder).setFailOnErrorParam(Boolean.FALSE));
            this.folder = null;
        }
        super.tearDown();
    }

    public void testBasicAuth() throws Exception {
        FolderObject folder;
        EnumAPI api = EnumAPI.OUTLOOK;
        int module = 2;
        OCLGuestPermission guestPermission = BasicAuthTest.createNamedGuestPermission("horst@example.com", "Horst Example", "secret");
        this.folder = folder = this.insertSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        BasicAuthTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        BasicAuthTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        BasicAuthTest.checkGuestPermission(guestPermission, guest);
        int n = 1;
        Appointment appointment = new Appointment();
        appointment.setStartDate(TimeTools.D("11.11.2014 08:00"));
        appointment.setEndDate(TimeTools.D("11.11.2014 09:00"));
        appointment.setTitle("Appointment #" + Integer.toString(n++));
        appointment.setParentFolderID(folder.getObjectID());
        appointment.setIgnoreConflicts(true);
        UserParticipant user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        UserParticipant guestParticipant = new UserParticipant(guestPermission.getEntity());
        user.setConfirm(0);
        appointment.setParticipants(new Participant[]{user, guestParticipant});
        appointment.setUsers(new UserParticipant[]{user, guestParticipant});
        this.calendarManager.insert(appointment);
        appointment = new Appointment();
        appointment.setStartDate(TimeTools.D("11.11.2014 10:00"));
        appointment.setEndDate(TimeTools.D("11.11.2014 11:00"));
        appointment.setTitle("Appointment #" + Integer.toString(n++));
        appointment.setParentFolderID(folder.getObjectID());
        appointment.setIgnoreConflicts(true);
        user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        guestParticipant = new UserParticipant(guestPermission.getEntity());
        user.setConfirm(0);
        appointment.setParticipants(new Participant[]{user, guestParticipant});
        appointment.setUsers(new UserParticipant[]{user, guestParticipant});
        this.calendarManager.insert(appointment);
        appointment = new Appointment();
        appointment.setStartDate(TimeTools.D("12.11.2014 08:00"));
        appointment.setEndDate(TimeTools.D("12.11.2014 09:00"));
        appointment.setTitle("Appointment #" + Integer.toString(n++));
        appointment.setParentFolderID(folder.getObjectID());
        appointment.setIgnoreConflicts(true);
        user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        guestParticipant = new UserParticipant(guestPermission.getEntity());
        user.setConfirm(0);
        appointment.setParticipants(new Participant[]{user, guestParticipant});
        appointment.setUsers(new UserParticipant[]{user, guestParticipant});
        this.calendarManager.insert(appointment);
        appointment = new Appointment();
        appointment.setStartDate(TimeTools.D("12.11.2014 10:00"));
        appointment.setEndDate(TimeTools.D("12.11.2014 11:00"));
        appointment.setTitle("Appointment #" + Integer.toString(n++));
        appointment.setParentFolderID(folder.getObjectID());
        appointment.setIgnoreConflicts(true);
        user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        guestParticipant = new UserParticipant(guestPermission.getEntity());
        user.setConfirm(0);
        appointment.setParticipants(new Participant[]{user, guestParticipant});
        appointment.setUsers(new UserParticipant[]{user, guestParticipant});
        this.calendarManager.insert(appointment);
        String shareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(shareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams httpParams = httpClient.getParams();
        httpParams.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        httpParams.setParameter("Content-Disposition", (Object)"attachment");
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)5000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        String password = ShareTest.getPassword(guestPermission.getRecipient());
        if (!Strings.isEmpty((String)password)) {
            String username = ShareTest.getUsername(guestPermission.getRecipient());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials anonymousCredentials = new UsernamePasswordCredentials(username, password);
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)anonymousCredentials);
            httpClient.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        HttpGet httpGet = new HttpGet(shareURL);
        httpGet.setHeader("Accept", "text/calendar");
        httpGet.setHeader("User-Agent", "Microsoft Outlook");
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        BasicAuthTest.assertEquals((String)"Wrong HTTP status", (int)200, (int)httpResponse.getStatusLine().getStatusCode());
        Header contentTypeHeader = httpResponse.getFirstHeader("Content-Type");
        BasicAuthTest.assertNotNull((String)"missing content-type header", (Object)contentTypeHeader);
        BasicAuthTest.assertEquals((String)"Unexpected Content-Type header", (String)"text/calendar", (String)contentTypeHeader.getValue());
        HttpEntity entity = httpResponse.getEntity();
        BasicAuthTest.assertNotNull((String)"No file downloaded", (Object)entity);
        byte[] downloadedFile = EntityUtils.toByteArray((HttpEntity)entity);
        Assert.assertNotNull((Object)downloadedFile);
        String ical = new String(downloadedFile, "UTF-8");
        BasicAuthTest.assertTrue((String)("Received content seems not be an ICal: " + ical), (boolean)ical.startsWith("BEGIN:VCALENDAR"));
    }
}

