/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.admin.rmi.dataobjects.UserModuleAccess;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import java.rmi.Naming;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Bug43270Test
extends ShareTest {
    private AJAXClient client2;
    private Map<Integer, FolderObject> foldersToDelete;

    public Bug43270Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.foldersToDelete = new HashMap<Integer, FolderObject>();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            if (null != this.client2) {
                if (null != this.foldersToDelete && 0 < this.foldersToDelete.size()) {
                    Bug43270Test.deleteFoldersSilently(this.client2, this.foldersToDelete);
                }
                this.client2.logout();
                this.prepareUser(true, null, null);
            }
        }
        finally {
            super.tearDown();
        }
    }

    public void testGetFolderLinkWithShareLinks() throws Exception {
        this.getFolderLink(false, Boolean.TRUE, Boolean.FALSE, null);
    }

    public void testGetFolderLinkWithShareLinksAndInviteGuests() throws Exception {
        this.getFolderLink(false, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testGetFolderLinkWithShareLinksAndInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.getFolderLink(true, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testDontGetFolderLink() throws Exception {
        this.getFolderLink(false, Boolean.FALSE, Boolean.FALSE, "SHR-0018");
    }

    public void testDontGetFolderLinkWithInviteGuests() throws Exception {
        this.getFolderLink(false, Boolean.FALSE, Boolean.TRUE, "SHR-0018");
    }

    public void testDontGetFolderLinkWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.getFolderLink(true, Boolean.FALSE, Boolean.TRUE, "SHR-0018");
    }

    public void testGetFileLinkWithShareLinks() throws Exception {
        this.getFileLink(false, Boolean.TRUE, Boolean.FALSE, null);
    }

    public void testGetFileLinkWithShareLinksAndInviteGuests() throws Exception {
        this.getFileLink(false, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testGetFileLinkWithShareLinksAndInviteGuestsAndReadCreateSharedFiles() throws Exception {
        this.getFileLink(true, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testDontGetFileLink() throws Exception {
        this.getFileLink(false, Boolean.FALSE, Boolean.FALSE, "SHR-0018");
    }

    public void testDontGetFileLinkWithInviteGuests() throws Exception {
        this.getFileLink(false, Boolean.FALSE, Boolean.TRUE, "SHR-0018");
    }

    public void testDontGetFileLinkWithInviteGuestsAndReadCreateSharedFiles() throws Exception {
        this.getFileLink(true, Boolean.FALSE, Boolean.TRUE, "SHR-0018");
    }

    public void testInviteGuestToFolderWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.inviteGuestToFolder(true, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testInviteGuestToFolderWithInviteGuestsAndShareLinksAndReadCreateSharedFolders() throws Exception {
        this.inviteGuestToFolder(true, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToFolder() throws Exception {
        this.inviteGuestToFolder(false, Boolean.FALSE, Boolean.FALSE, "SHR-0019");
    }

    public void testInviteGuestToFolderWithInviteGuests() throws Exception {
        this.inviteGuestToFolder(false, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToFolderWithShareLinks() throws Exception {
        this.inviteGuestToFolder(false, Boolean.TRUE, Boolean.FALSE, "SHR-0019");
    }

    public void testInviteGuestToFolderWithInviteGuestsAndShareLinks() throws Exception {
        this.inviteGuestToFolder(false, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToFolderWithShareLinksAndReadCreateSharedFolders() throws Exception {
        this.inviteGuestToFolder(true, Boolean.TRUE, Boolean.FALSE, "SHR-0019");
    }

    public void testInviteGuestToFileWithInviteGuestsAndReadCreateSharedFiles() throws Exception {
        this.inviteGuestToFile(true, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testInviteGuestToFileWithInviteGuestsAndShareLinksAndReadCreateSharedFiles() throws Exception {
        this.inviteGuestToFile(true, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToFile() throws Exception {
        this.inviteGuestToFile(false, Boolean.FALSE, Boolean.FALSE, "SHR-0019");
    }

    public void testInviteGuestToFileWithInviteGuests() throws Exception {
        this.inviteGuestToFile(false, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToFileWithShareLinks() throws Exception {
        this.inviteGuestToFile(false, Boolean.TRUE, Boolean.FALSE, "SHR-0019");
    }

    public void testInviteGuestToFileWithInviteGuestsAndShareLinks() throws Exception {
        this.inviteGuestToFile(false, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToFileWithShareLinksAndReadCreateSharedFiles() throws Exception {
        this.inviteGuestToFile(true, Boolean.TRUE, Boolean.FALSE, "SHR-0019");
    }

    public void testInviteUserToFolderWithReadCreateSharedFolders() throws Exception {
        this.inviteUserToFolder(true, Boolean.FALSE, Boolean.FALSE, null);
    }

    public void testInviteUserToFolderWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.inviteUserToFolder(true, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testInviteUserToFolderWithInviteGuestsAndShareLinksAndReadCreateSharedFolders() throws Exception {
        this.inviteUserToFolder(true, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testInviteUserToFolder() throws Exception {
        this.inviteUserToFolder(false, Boolean.FALSE, Boolean.FALSE, null);
    }

    public void testInviteUserToFolderWithInviteGuests() throws Exception {
        this.inviteUserToFolder(false, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testInviteUserToFolderWithShareLinks() throws Exception {
        this.inviteUserToFolder(false, Boolean.TRUE, Boolean.FALSE, null);
    }

    public void testInviteUserToFolderWithInviteGuestsAndShareLinks() throws Exception {
        this.inviteUserToFolder(false, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testInviteUserToFileWithReadCreateSharedFolders() throws Exception {
        this.inviteUserToFile(true, Boolean.FALSE, Boolean.FALSE, null);
    }

    public void testInviteUserToFileWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.inviteUserToFile(true, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testInviteUserToFileWithInviteGuestsAndShareLinksAndReadCreateSharedFolders() throws Exception {
        this.inviteUserToFile(true, Boolean.TRUE, Boolean.TRUE, null);
    }

    public void testInviteUserToFile() throws Exception {
        this.inviteUserToFile(false, Boolean.FALSE, Boolean.FALSE, null);
    }

    public void testInviteUserToFileWithInviteGuests() throws Exception {
        this.inviteUserToFile(false, Boolean.FALSE, Boolean.TRUE, null);
    }

    public void testInviteUserToFileWithShareLinks() throws Exception {
        this.inviteUserToFile(false, Boolean.TRUE, Boolean.FALSE, null);
    }

    public void testInviteUserToFileWithInviteGuestsAndShareLinks() throws Exception {
        this.inviteUserToFile(false, Boolean.TRUE, Boolean.TRUE, null);
    }

    private void setReadCreateSharedFolders(boolean readCreateSharedFolders) throws Exception {
        Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
        OXUserInterface userInterface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        User user = new User(this.client2.getValues().getUserId());
        Context context = new Context(Integer.valueOf(this.client2.getValues().getContextId()));
        UserModuleAccess moduleAccess = userInterface.getModuleAccess(context, user, credentials);
        moduleAccess.setReadCreateSharedFolders(readCreateSharedFolders);
        userInterface.changeModuleAccess(context, user, moduleAccess, credentials);
    }

    private void setInviteGuests(Boolean inviteGuests) throws Exception {
        this.changeCapability("invite_guests", inviteGuests);
    }

    private void setShareLinks(Boolean shareLinks) throws Exception {
        this.changeCapability("share_links", shareLinks);
    }

    private void changeCapability(String capability, Boolean value) throws Exception {
        Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
        OXUserInterface userInterface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        User user = new User(this.client2.getValues().getUserId());
        Context context = new Context(Integer.valueOf(this.client2.getValues().getContextId()));
        if (null == value) {
            userInterface.changeCapabilities(context, user, Collections.emptySet(), Collections.emptySet(), Collections.singleton(capability), credentials);
        } else if (Boolean.TRUE.equals(value)) {
            userInterface.changeCapabilities(context, user, Collections.singleton(capability), Collections.emptySet(), Collections.emptySet(), credentials);
        } else {
            userInterface.changeCapabilities(context, user, Collections.emptySet(), Collections.singleton(capability), Collections.emptySet(), credentials);
        }
    }

    private void prepareUser(boolean readCreateSharedFolders, Boolean shareLinks, Boolean inviteGuests) throws Exception {
        this.setShareLinks(shareLinks);
        this.setInviteGuests(inviteGuests);
        this.setReadCreateSharedFolders(readCreateSharedFolders);
    }

    private void getFolderLink(boolean readCreateSharedFolders, Boolean shareLinks, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, shareLinks, inviteGuests);
        FolderObject folder = Bug43270Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, Bug43270Test.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        GetLinkRequest getLinkRequest = new GetLinkRequest(new ShareTarget(8, String.valueOf(folder.getObjectID())));
        getLinkRequest.setFailOnError(false);
        this.executeAndCheck(getLinkRequest, expectedError);
    }

    private void getFileLink(boolean readCreateSharedFolders, Boolean shareLinks, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, shareLinks, inviteGuests);
        FolderObject folder = Bug43270Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, Bug43270Test.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        File file = Bug43270Test.insertFile(this.client2, folder.getObjectID(), Bug43270Test.randomUID());
        GetLinkRequest getLinkRequest = new GetLinkRequest(new ShareTarget(8, file.getFolderId(), file.getId()));
        getLinkRequest.setFailOnError(false);
        this.executeAndCheck(getLinkRequest, expectedError);
    }

    private void inviteGuestToFolder(boolean readCreateSharedFolders, Boolean shareLinks, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, shareLinks, inviteGuests);
        FolderObject folder = Bug43270Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, Bug43270Test.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        folder.getPermissions().add(Bug43270Test.createNamedAuthorPermission(Bug43270Test.randomUID() + "@example.com", Bug43270Test.randomUID()));
        UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void inviteUserToFolder(boolean readCreateSharedFolders, Boolean shareLinks, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, shareLinks, inviteGuests);
        FolderObject folder = Bug43270Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, Bug43270Test.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        OCLPermission permission = new OCLPermission(this.getClient().getValues().getUserId(), folder.getObjectID());
        permission.setAllPermission(4, 4, 4, 0);
        folder.getPermissions().add(permission);
        UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void inviteGuestToFile(boolean readCreateSharedFolders, Boolean shareLinks, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, shareLinks, inviteGuests);
        FolderObject folder = Bug43270Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, Bug43270Test.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        File file = Bug43270Test.insertFile(this.client2, folder.getObjectID(), Bug43270Test.randomUID());
        FileStorageGuestObjectPermission guestPermission = Bug43270Test.asObjectPermission(Bug43270Test.createNamedAuthorPermission(Bug43270Test.randomUID() + "@example.com", Bug43270Test.randomUID()));
        file.setObjectPermissions(Collections.singletonList(guestPermission));
        UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest(file, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, file.getLastModified());
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void inviteUserToFile(boolean readCreateSharedFolders, Boolean shareLinks, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, shareLinks, inviteGuests);
        FolderObject folder = Bug43270Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, 8, Bug43270Test.getDefaultFolder(this.client2, 8));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        File file = Bug43270Test.insertFile(this.client2, folder.getObjectID(), Bug43270Test.randomUID());
        DefaultFileStorageObjectPermission permission = new DefaultFileStorageObjectPermission(this.getClient().getValues().getUserId(), false, 2);
        file.setObjectPermissions(Collections.singletonList(permission));
        UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest(file, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, file.getLastModified());
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void executeAndCheck(AJAXRequest<?> request, String expectedError) throws Exception {
        Object response = this.client2.execute(request);
        if (null == expectedError) {
            Bug43270Test.assertFalse((String)((AbstractAJAXResponse)((Object)response)).getErrorMessage(), (boolean)((AbstractAJAXResponse)((Object)response)).hasError());
        } else {
            Bug43270Test.assertTrue((String)"No error in response", (boolean)((AbstractAJAXResponse)((Object)response)).hasError());
            Bug43270Test.assertEquals((String)"Unexpected error code", (String)expectedError, (String)((AbstractAJAXResponse)((Object)response)).getException().getErrorCode());
        }
    }
}

