/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.java.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import junitx.framework.Assert;

public class ResolveShareResponse
extends AbstractAJAXResponse {
    public static final String NOT_FOUND = "not_found";
    public static final String NOT_FOUND_CONTINUE = "not_found_continue";
    private final String path;
    private final Map<String, String> parameters;
    private final int statusCode;

    public ResolveShareResponse(int statusCode, String path, Map<String, String> parameters) {
        super(null);
        this.statusCode = statusCode;
        this.parameters = parameters;
        this.path = path;
    }

    public String getShare() {
        return this.parameters.get("share");
    }

    public String getTarget() {
        return this.parameters.get("target");
    }

    public String getLoginType() {
        return this.parameters.get("login_type");
    }

    public String getLoginName() {
        String name = this.parameters.get("login_name");
        if (null != name) {
            try {
                return URLDecoder.decode(name, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Assert.fail((Throwable)e);
            }
        }
        return name;
    }

    public String getPath() {
        return this.path;
    }

    public String getSessionID() {
        return this.parameters.get("session");
    }

    public String getUser() {
        return this.parameters.get("user");
    }

    public int getUserId() {
        String id = this.parameters.get("user_id");
        if (!Strings.isEmpty((String)id)) {
            return Integer.valueOf(id);
        }
        return 0;
    }

    public String getLanguage() {
        return this.parameters.get("language");
    }

    public boolean isStore() {
        return Boolean.valueOf(this.parameters.get("store"));
    }

    public String getModule() {
        String app = this.parameters.get("app");
        return Strings.isEmpty((String)app) ? this.parameters.get("m") : app;
    }

    public String getFolder() {
        String folder = this.parameters.get("folder");
        return Strings.isEmpty((String)folder) ? this.parameters.get("f") : folder;
    }

    public String getItem() {
        String id = this.parameters.get("id");
        return Strings.isEmpty((String)id) ? this.parameters.get("i") : id;
    }

    public String getStatus() {
        return this.parameters.get("status");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.parameters.get("message");
    }

    public String getMessageType() {
        return this.parameters.get("message_type");
    }
}

