/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.reminder.actions.AbstractReminderRequest;
import com.openexchange.ajax.reminder.actions.RemindAgainParser;
import com.openexchange.ajax.reminder.actions.RemindAgainResponse;
import com.openexchange.groupware.reminder.ReminderObject;
import org.json.JSONException;

public class RemindAgainRequest
extends AbstractReminderRequest<RemindAgainResponse> {
    private final ReminderObject reminder;

    public RemindAgainRequest(ReminderObject reminder) {
        if (null == reminder) {
            throw new NullPointerException("reminder is null.");
        }
        if (reminder.getObjectId() <= 0) {
            throw new IllegalArgumentException("Missing identifier in reminder.");
        }
        if (null == reminder.getDate()) {
            throw new IllegalArgumentException("Missing alarm date in reminder.");
        }
        this.reminder = reminder;
    }

    @Override
    public Object getBody() throws JSONException {
        return this.convert(this.reminder);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "remindAgain"), new AJAXRequest.Parameter("id", String.valueOf(this.reminder.getObjectId()))};
    }

    public RemindAgainParser getParser() {
        return new RemindAgainParser();
    }
}

