/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.DeleteResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteRequest
extends AbstractMailRequest<DeleteResponse> {
    private final String[][] folderAndMailIds;
    private final boolean hardDelete;
    private boolean failOnError = true;

    public DeleteRequest(String folder, String id, boolean hardDelete) {
        this(new String[][]{{folder, id}}, hardDelete);
    }

    public DeleteRequest(String[] folderAndMailId, boolean hardDelete) {
        this(new String[][]{folderAndMailId}, hardDelete);
    }

    public DeleteRequest(String[][] folderAndMailIds) {
        this(folderAndMailIds, false);
    }

    public DeleteRequest(String[][] folderAndMailIds, boolean hardDelete) {
        this.folderAndMailIds = folderAndMailIds;
        this.hardDelete = hardDelete;
    }

    public DeleteRequest(TestMail mail, boolean hardDelete) {
        this.folderAndMailIds = new String[][]{mail.getFolderAndId()};
        this.hardDelete = hardDelete;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("harddelete", this.hardDelete ? "1" : "0")};
    }

    @Override
    public AbstractAJAXParser<DeleteResponse> getParser() {
        return new AbstractAJAXParser<DeleteResponse>(this.failOnError){

            @Override
            protected DeleteResponse createResponse(Response response) {
                return new DeleteResponse(response);
            }
        };
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray array = new JSONArray();
        for (String[] folderAndObject : this.folderAndMailIds) {
            JSONObject json = new JSONObject();
            json.put("folder", (Object)folderAndObject[0]);
            json.put("id", (Object)folderAndObject[1]);
            array.put((Object)json);
        }
        return array;
    }

    public DeleteRequest ignoreError() {
        this.failOnError = false;
        return this;
    }

    public DeleteRequest failOnError() {
        this.failOnError = true;
        return this;
    }
}

