/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.ClearResponse;
import org.json.JSONArray;
import org.json.JSONException;

public class ClearRequest
extends AbstractMailRequest<ClearResponse> {
    private final String[] folderIds;
    private boolean hardDelete = false;
    private boolean failOnError = true;

    public ClearRequest(String folderId) {
        this.folderIds = new String[]{folderId};
    }

    public ClearRequest(String[] folderIds) {
        this.folderIds = folderIds;
    }

    public ClearRequest(String[] folderIds, boolean failOnError) {
        this.folderIds = folderIds;
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray array = new JSONArray();
        for (String folderId : this.folderIds) {
            array.put((Object)folderId);
        }
        return array;
    }

    public ClearRequest setHardDelete(boolean hardDelete) {
        this.hardDelete = hardDelete;
        return this;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "clear"), new AJAXRequest.Parameter("harddelete", this.hardDelete)};
    }

    @Override
    public AbstractAJAXParser<ClearResponse> getParser() {
        return new AbstractAJAXParser<ClearResponse>(this.failOnError){

            @Override
            protected ClearResponse createResponse(Response response) throws JSONException {
                return new ClearResponse(response);
            }
        };
    }
}

