/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.Order;
import com.openexchange.mail.MailJSONField;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug30903Test
extends AbstractMailTest {
    private static String mail = "Message-Id: <blah@non-existent.com>\nX-Mailer: AppSuite 7.6.0 \nDate: Tue, 08 Apr 2014 13:37:00 +0100\nFrom: #ADDR#\nTo: #ADDR#\nSubject: Bug30903\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\n\nTesting";
    private final String[][] fmids = new String[2][2];

    public Bug30903Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        DeleteRequest delReq = new DeleteRequest(this.fmids, true);
        this.client.execute(delReq);
        super.tearDown();
    }

    public void testDeleteDraft() throws OXException, IOException, JSONException {
        Object[][] objArray;
        UserValues values = this.client.getValues();
        NewMailRequest newMailReq = new NewMailRequest(values.getDraftsFolder(), mail.replaceAll("#ADDR#", values.getSendAddress()), MailFlag.DRAFT.getValue());
        NewMailResponse newMailResp = this.client.execute(newMailReq);
        Bug30903Test.assertNotNull((Object)((Object)newMailResp));
        String draftID = newMailResp.getId();
        this.fmids[0][0] = values.getDraftsFolder();
        this.fmids[0][1] = draftID;
        GetRequest getReq = new GetRequest(values.getDraftsFolder(), draftID);
        GetResponse getResp = this.client.execute(getReq);
        Bug30903Test.assertNotNull((Object)((Object)getResp));
        JSONObject data = (JSONObject)getResp.getData();
        String msgref = data.getString("msgref");
        JSONObject jsonMail = new JSONObject();
        jsonMail.put(MailJSONField.FROM.getKey(), (Object)values.getSendAddress());
        jsonMail.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)values.getSendAddress());
        jsonMail.put(MailJSONField.RECIPIENT_CC.getKey(), (Object)"");
        jsonMail.put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)"");
        jsonMail.put(MailJSONField.SUBJECT.getKey(), (Object)"Bug30903");
        jsonMail.put(MailJSONField.PRIORITY.getKey(), (Object)"3");
        jsonMail.put("sendtype", 6);
        jsonMail.put(MailJSONField.MSGREF.getKey(), (Object)msgref);
        JSONObject jAttachment = new JSONObject(2);
        jAttachment.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)"text/plain; charset=\"UTF-8\"");
        jAttachment.put(MailJSONField.CONTENT.getKey(), (Object)"Testing\nAdded a few lines\nFoo bar\nand lorem ipsum\n.");
        JSONArray jAttachments = new JSONArray(1);
        jAttachments.put((Object)jAttachment);
        jsonMail.put(MailJSONField.ATTACHMENTS.getKey(), (Object)jAttachments);
        SendRequest sendRequest = new SendRequest(jsonMail.toString());
        SendResponse sendResponse = this.client.execute(sendRequest);
        Bug30903Test.assertNotNull((Object)((Object)sendResponse));
        this.fmids[1] = sendResponse.getFolderAndID();
        AllRequest allReq = new AllRequest(values.getDraftsFolder(), COLUMNS_FOLDER_ID, 0, Order.ASCENDING, true);
        AllResponse allResp = this.client.execute(allReq);
        Bug30903Test.assertNotNull((Object)allResp);
        for (Object[] o : objArray = allResp.getArray()) {
            String s = (String)o[1];
            if (Integer.parseInt(s) != Integer.parseInt(draftID)) continue;
            Bug30903Test.fail((String)"Draft mail still in 'Drafts' folder");
        }
    }
}

