/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.appointments;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.kata.AbstractStep;
import com.openexchange.ajax.kata.IdentitySource;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import org.junit.Assert;

public class AppointmentCreateStep
extends AbstractStep
implements IdentitySource<Appointment> {
    private final Appointment entry;
    private CalendarTestManager manager;
    private boolean inserted;

    public AppointmentCreateStep(Appointment entry, String name, String expectedError) {
        super(name, expectedError);
        this.entry = entry;
        this.expectedError = expectedError;
    }

    @Override
    public void cleanUp() throws Exception {
        if (!this.inserted) {
            return;
        }
        this.manager.delete(this.entry, false);
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.client = client;
        this.manager = new CalendarTestManager(client);
        InsertRequest insertRequest = new InsertRequest(this.entry, this.getTimeZone(), false);
        this.inserted = false;
        AppointmentInsertResponse insertResponse = this.execute(insertRequest);
        insertResponse.fillAppointment(this.entry);
        boolean bl = this.inserted = !insertResponse.hasError() && !insertResponse.hasConflicts();
        if (insertResponse.hasConflicts()) {
            StringBuilder conflicts = new StringBuilder("Conflicting appointments: ");
            for (ConflictObject conflict : insertResponse.getConflicts()) {
                conflicts.append(conflict.getTitle());
                conflicts.append(", ");
            }
            Assert.fail((String)(this.name + " " + conflicts.substring(0, conflicts.length() - 2)));
        }
        this.checkError(insertResponse);
    }

    @Override
    public void assumeIdentity(Appointment newApp) {
        newApp.setObjectID(this.entry.getObjectID());
        newApp.setParentFolderID(this.entry.getParentFolderID());
        newApp.setLastModified(this.entry.getLastModified());
    }

    @Override
    public void rememberIdentityValues(Appointment appointment) {
        this.entry.setLastModified(appointment.getLastModified());
        this.entry.setParentFolderID(appointment.getParentFolderID());
    }

    @Override
    public void forgetIdentity(Appointment entry) {
        this.inserted = false;
    }

    @Override
    public Class<Appointment> getType() {
        return Appointment.class;
    }
}

