/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.folder.AbstractObjectCountTest;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.infostore.actions.ZipDocumentsRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.folderstorage.Folder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.FolderTestManager;
import com.openexchange.test.TestInit;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import org.junit.Test;

public final class ZipDocumentsTest
extends AbstractObjectCountTest {
    public ZipDocumentsTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipDocumentsInInfostoreFolder() throws Exception {
        FolderTestManager folderTestManager = new FolderTestManager(this.client1);
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client1);
        try {
            FolderObject created = ZipDocumentsTest.createPrivateFolder(this.client1, folderTestManager, 8);
            Folder folder = ZipDocumentsTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            int objectsInFolder = folder.getTotal();
            ZipDocumentsTest.assertEquals((String)"Wrong object count", (int)0, (int)objectsInFolder);
            DefaultFile expected = new DefaultFile();
            expected.setCreated(new Date());
            expected.setFolderId(folder.getID());
            expected.setTitle("InfostoreCreateDeleteTest File1");
            expected.setLastModified(new Date());
            File file = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
            infostoreTestManager.newAction((com.openexchange.file.storage.File)expected, file);
            ZipDocumentsTest.assertFalse((String)"Creating an entry should work", (boolean)infostoreTestManager.getLastResponse().hasError());
            String id1 = expected.getId();
            com.openexchange.file.storage.File actual = infostoreTestManager.getAction(expected.getId());
            ZipDocumentsTest.assertEquals((String)"Name should be the same", (String)expected.getTitle(), (String)actual.getTitle());
            DefaultFile expected2 = new DefaultFile();
            expected2.setCreated(new Date());
            expected2.setFolderId(folder.getID());
            expected2.setTitle("InfostoreCreateDeleteTest File2");
            expected2.setLastModified(new Date());
            File file2 = new File(TestInit.getTestProperty("webdavPropertiesFile"));
            infostoreTestManager.newAction((com.openexchange.file.storage.File)expected2, file2);
            ZipDocumentsTest.assertFalse((String)"Creating an entry should work", (boolean)infostoreTestManager.getLastResponse().hasError());
            String id2 = expected2.getId();
            com.openexchange.file.storage.File actual2 = infostoreTestManager.getAction(expected2.getId());
            ZipDocumentsTest.assertEquals((String)"Name should be the same", (String)expected2.getTitle(), (String)actual2.getTitle());
            LinkedList<ZipDocumentsRequest.IdVersionPair> pairs = new LinkedList<ZipDocumentsRequest.IdVersionPair>();
            pairs.add(new ZipDocumentsRequest.IdVersionPair(id1, null));
            pairs.add(new ZipDocumentsRequest.IdVersionPair(id2, null));
            ZipDocumentsRequest request = new ZipDocumentsRequest(pairs, folder.getID());
            WebResponse webResponse = Executor.execute4Download(this.getSession(), request, AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL), AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME));
            ZipDocumentsTest.assertEquals((String)"Unexpected Content-Type.", (String)"application/zip", (String)webResponse.getContentType());
        }
        finally {
            infostoreTestManager.cleanUp();
            folderTestManager.cleanUp();
        }
    }
}

