/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.util.UUIDs;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug6825Test
extends AbstractAJAXSession {
    private FolderTestManager folderTestManager;

    public Bug6825Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folderTestManager = new FolderTestManager(this.getClient());
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.folderTestManager) {
            this.folderTestManager.cleanUp();
        }
        super.tearDown();
    }

    public void testImportVCard() throws Exception {
        FolderObject folder = this.folderTestManager.generatePrivateFolder(UUIDs.getUnformattedStringFromRandom(), Module.CONTACTS.getFolderConstant(), this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        folder = this.folderTestManager.insertFolderOnServer(folder);
        String originalSurname = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmmmmnnnnnnnnnnooooooooooppppppppppqqqqqqqqqqrrrrrrrrrrttttttttttuuuuuuuuuvvvvvvvvvwwwwwwwwwwxxxxxxxxxxyyyyyyyyyyzzzzzzzzzz00000000001111111111222222222233333333334444444444455555555556666666666777777777788888888889999999999";
        String expectedSurname = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjjkkkkkkkkkkllllllllllmmmmmmmm";
        String vCard = "BEGIN:VCARD\nVERSION:3.0\n\nN:" + originalSurname + ";givenName;;;\nEND:VCARD\n";
        VCardImportRequest importRequest = new VCardImportRequest(folder.getObjectID(), Streams.newByteArrayInputStream((byte[])vCard.getBytes(Charsets.UTF_8)));
        VCardImportResponse importResponse = this.getClient().execute(importRequest);
        JSONArray response = (JSONArray)importResponse.getData();
        Bug6825Test.assertEquals((String)"Unexpected number of imported contacts", (int)1, (int)response.length());
        JSONObject jsonObject = response.getJSONObject(0);
        Contact contact = new ContactTestManager(this.getClient()).getAction(jsonObject.getInt("folder_id"), jsonObject.getInt("id"));
        Bug6825Test.assertNotNull((String)"Imported contact not found", (Object)contact);
        Bug6825Test.assertEquals((String)"Surname not truncated as expected", (String)expectedSurname, (String)contact.getSurName());
    }

    public void testImportICal() throws Exception {
        FolderObject folder = this.folderTestManager.generatePrivateFolder(UUIDs.getUnformattedStringFromRandom(), Module.CALENDAR.getFolderConstant(), this.getClient().getValues().getPrivateAppointmentFolder(), this.getClient().getValues().getUserId());
        folder = this.folderTestManager.insertFolderOnServer(folder);
        String testMailAddress = "test@example.com";
        String originalTitle = "zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... ";
        String expectedTitle = "zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen.... zwanzig zeichen";
        String iCal = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20060519T120300Z\nDTSTART:20060519T110000Z\nDTSTAMP:20070423T063205Z\nSUMMARY:" + originalTitle + "\nDTEND:20060519T120000Z\nATTENDEE:mailto:" + testMailAddress + "\nEND:VEVENT\nEND:VCALENDAR";
        ICalImportRequest importRequest = new ICalImportRequest(folder.getObjectID(), iCal, false);
        ICalImportResponse importResponse = this.getClient().execute(importRequest);
        Bug6825Test.assertTrue((boolean)importResponse.hasError());
        JSONObject data = ((JSONArray)importResponse.getData()).getJSONObject(0);
        Bug6825Test.assertTrue((boolean)data.has("warnings"));
        JSONArray warnings = data.getJSONArray("warnings");
        Bug6825Test.assertEquals((int)1, (int)warnings.length());
        Bug6825Test.assertTrue((boolean)warnings.getJSONObject(0).toString().contains("truncated"));
        JSONArray response = (JSONArray)importResponse.getData();
        Bug6825Test.assertEquals((String)"Unexpected number of imported appointments", (int)1, (int)response.length());
        JSONObject jsonObject = response.getJSONObject(0);
        Appointment appointment = new CalendarTestManager(this.getClient()).get(jsonObject.getInt("folder_id"), jsonObject.getInt("id"));
        Bug6825Test.assertNotNull((String)"Imported appointment not found", (Object)appointment);
        Bug6825Test.assertEquals((String)"Surname not truncated as expected", (String)expectedTitle, (String)appointment.getTitle());
    }
}

